/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.savepoints;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.util.function.TriFunction;

public final class SavepointTestUtilities {
    public static TriFunction<AsynchronousJobOperationKey, String, SavepointFormatType, CompletableFuture<Acknowledge>> setReferenceToOperationKey(AtomicReference<AsynchronousJobOperationKey> keyReference) {
        return (operationKey, directory, formatType) -> {
            keyReference.set((AsynchronousJobOperationKey)operationKey);
            return CompletableFuture.completedFuture(Acknowledge.get());
        };
    }

    public static Function<AsynchronousJobOperationKey, CompletableFuture<OperationResult<String>>> getResultIfKeyMatches(OperationResult<String> resultToReturn, AtomicReference<AsynchronousJobOperationKey> expectedKeyReference) {
        return operationKey -> {
            if (operationKey.equals(expectedKeyReference.get())) {
                return CompletableFuture.completedFuture(resultToReturn);
            }
            throw new RuntimeException("Expected operation key " + expectedKeyReference.get() + ", but received " + operationKey);
        };
    }

    private SavepointTestUtilities() {
    }
}

