/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.MutableObjectIterator;

public class UniformIntTupleGenerator
implements MutableObjectIterator<Tuple2<Integer, Integer>> {
    private final int numKeys;
    private final int numVals;
    private int keyCnt = 0;
    private int valCnt = 0;
    private boolean repeatKey;

    public UniformIntTupleGenerator(int numKeys, int numVals, boolean repeatKey) {
        this.numKeys = numKeys;
        this.numVals = numVals;
        this.repeatKey = repeatKey;
    }

    public Tuple2<Integer, Integer> next(Tuple2<Integer, Integer> target) {
        if (!this.repeatKey) {
            if (this.valCnt >= this.numVals) {
                return null;
            }
            target.f0 = this.keyCnt++;
            target.f1 = this.valCnt;
            if (this.keyCnt == this.numKeys) {
                this.keyCnt = 0;
                ++this.valCnt;
            }
        } else {
            if (this.keyCnt >= this.numKeys) {
                return null;
            }
            target.f0 = this.keyCnt;
            target.f1 = this.valCnt++;
            if (this.valCnt == this.numVals) {
                this.valCnt = 0;
                ++this.keyCnt;
            }
        }
        return target;
    }

    public Tuple2<Integer, Integer> next() {
        return this.next((Tuple2<Integer, Integer>)new Tuple2());
    }
}

