/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferTest;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadOnlySlicedBufferTest {
    private static final int BUFFER_SIZE = 1024;
    private static final int DATA_SIZE = 10;
    private NetworkBuffer buffer;

    @Before
    public void setUp() throws Exception {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        this.buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, Buffer.DataType.DATA_BUFFER, 0);
        for (int i = 0; i < 10; ++i) {
            this.buffer.writeByte(i);
        }
    }

    @Test
    public void testForwardsIsBuffer() throws IOException {
        Assert.assertEquals((Object)this.buffer.isBuffer(), (Object)this.buffer.readOnlySlice().isBuffer());
        Assert.assertEquals((Object)this.buffer.isBuffer(), (Object)this.buffer.readOnlySlice(1, 2).isBuffer());
        Buffer eventBuffer = EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE, (boolean)false);
        Assert.assertEquals((Object)eventBuffer.isBuffer(), (Object)eventBuffer.readOnlySlice().isBuffer());
        Assert.assertEquals((Object)eventBuffer.isBuffer(), (Object)eventBuffer.readOnlySlice(1, 2).isBuffer());
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetDataTypeThrows1() {
        this.buffer.readOnlySlice().setDataType(Buffer.DataType.EVENT_BUFFER);
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testSetDataTypeThrows2() {
        this.buffer.readOnlySlice(1, 2).setDataType(Buffer.DataType.EVENT_BUFFER);
    }

    @Test
    public void testForwardsGetMemorySegment() {
        Assert.assertSame((Object)this.buffer.getMemorySegment(), (Object)this.buffer.readOnlySlice().getMemorySegment());
        Assert.assertSame((Object)this.buffer.getMemorySegment(), (Object)this.buffer.readOnlySlice(1, 2).getMemorySegment());
    }

    @Test
    public void testForwardsGetRecycler() {
        Assert.assertSame((Object)this.buffer.getRecycler(), (Object)this.buffer.readOnlySlice().getRecycler());
        Assert.assertSame((Object)this.buffer.getRecycler(), (Object)this.buffer.readOnlySlice(1, 2).getRecycler());
    }

    @Test
    public void testForwardsRecycleBuffer1() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice();
        Assert.assertFalse((boolean)slice.isRecycled());
        slice.recycleBuffer();
        Assert.assertTrue((boolean)slice.isRecycled());
        Assert.assertTrue((boolean)this.buffer.isRecycled());
    }

    @Test
    public void testForwardsRecycleBuffer2() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice(1, 2);
        Assert.assertFalse((boolean)slice.isRecycled());
        slice.recycleBuffer();
        Assert.assertTrue((boolean)slice.isRecycled());
        Assert.assertTrue((boolean)this.buffer.isRecycled());
    }

    @Test
    public void testForwardsRetainBuffer1() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice();
        Assert.assertEquals((long)this.buffer.refCnt(), (long)slice.refCnt());
        slice.retainBuffer();
        Assert.assertEquals((long)this.buffer.refCnt(), (long)slice.refCnt());
    }

    @Test
    public void testForwardsRetainBuffer2() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice(1, 2);
        Assert.assertEquals((long)this.buffer.refCnt(), (long)slice.refCnt());
        slice.retainBuffer();
        Assert.assertEquals((long)this.buffer.refCnt(), (long)slice.refCnt());
    }

    @Test
    public void testCreateSlice1() {
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice();
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice();
        Assert.assertSame((Object)this.buffer, (Object)slice2.unwrap().unwrap());
        Assert.assertSame((Object)slice1.getMemorySegment(), (Object)slice2.getMemorySegment());
        Assert.assertEquals((long)1L, (long)slice1.getMemorySegmentOffset());
        Assert.assertEquals((long)slice1.getMemorySegmentOffset(), (long)slice2.getMemorySegmentOffset());
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testCreateSlice2() {
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice();
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice(1, 2);
        Assert.assertSame((Object)this.buffer, (Object)slice2.unwrap().unwrap());
        Assert.assertSame((Object)slice1.getMemorySegment(), (Object)slice2.getMemorySegment());
        Assert.assertEquals((long)1L, (long)slice1.getMemorySegmentOffset());
        Assert.assertEquals((long)2L, (long)slice2.getMemorySegmentOffset());
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 2, 3);
    }

    @Test
    public void testCreateSlice3() {
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice(1, 2);
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice();
        Assert.assertSame((Object)this.buffer, (Object)slice2.unwrap().unwrap());
        Assert.assertSame((Object)slice1.getMemorySegment(), (Object)slice2.getMemorySegment());
        Assert.assertEquals((long)1L, (long)slice1.getMemorySegmentOffset());
        Assert.assertEquals((long)1L, (long)slice2.getMemorySegmentOffset());
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 1, 2);
    }

    @Test
    public void testCreateSlice4() {
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice(1, 5);
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice(1, 2);
        Assert.assertSame((Object)this.buffer, (Object)slice2.unwrap().unwrap());
        Assert.assertSame((Object)slice1.getMemorySegment(), (Object)slice2.getMemorySegment());
        Assert.assertEquals((long)1L, (long)slice1.getMemorySegmentOffset());
        Assert.assertEquals((long)2L, (long)slice2.getMemorySegmentOffset());
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 2, 3);
    }

    @Test
    public void testGetMaxCapacity() {
        Assert.assertEquals((long)10L, (long)this.buffer.readOnlySlice().getMaxCapacity());
        Assert.assertEquals((long)2L, (long)this.buffer.readOnlySlice(1, 2).getMaxCapacity());
    }

    @Test
    public void testGetSetReaderIndex1() {
        this.testGetSetReaderIndex(this.buffer.readOnlySlice());
    }

    @Test
    public void testGetSetReaderIndex2() {
        this.testGetSetReaderIndex(this.buffer.readOnlySlice(1, 2));
    }

    private void testGetSetReaderIndex(ReadOnlySlicedNetworkBuffer slice) {
        Assert.assertEquals((long)0L, (long)this.buffer.getReaderIndex());
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        slice.setReaderIndex(1);
        Assert.assertEquals((long)0L, (long)this.buffer.getReaderIndex());
        Assert.assertEquals((long)1L, (long)slice.getReaderIndex());
    }

    @Test
    public void testGetSetSize1() {
        this.testGetSetSize(this.buffer.readOnlySlice(), 10);
    }

    @Test
    public void testGetSetSize2() {
        this.testGetSetSize(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetSetSize(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        Assert.assertEquals((long)10L, (long)this.buffer.getSize());
        Assert.assertEquals((long)sliceSize, (long)slice.getSize());
        this.buffer.setSize(11);
        Assert.assertEquals((long)11L, (long)this.buffer.getSize());
        Assert.assertEquals((long)sliceSize, (long)slice.getSize());
    }

    @Test
    public void testReadableBytes() {
        Assert.assertEquals((long)this.buffer.readableBytes(), (long)this.buffer.readOnlySlice().readableBytes());
        Assert.assertEquals((long)2L, (long)this.buffer.readOnlySlice(1, 2).readableBytes());
    }

    @Test
    public void testGetNioBufferReadable1() {
        this.testGetNioBufferReadable(this.buffer.readOnlySlice(), 10);
    }

    @Test
    public void testGetNioBufferReadable2() {
        this.testGetNioBufferReadable(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetNioBufferReadable(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        ByteBuffer sliceByteBuffer = slice.getNioBufferReadable();
        Assert.assertTrue((boolean)sliceByteBuffer.isReadOnly());
        Assert.assertEquals((long)sliceSize, (long)sliceByteBuffer.remaining());
        Assert.assertEquals((long)sliceSize, (long)sliceByteBuffer.limit());
        Assert.assertEquals((long)sliceSize, (long)sliceByteBuffer.capacity());
        sliceByteBuffer.position(1);
        Assert.assertEquals((long)0L, (long)this.buffer.getReaderIndex());
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)this.buffer.getSize());
        Assert.assertEquals((long)sliceSize, (long)slice.getSize());
    }

    @Test
    public void testGetNioBuffer1() {
        this.testGetNioBuffer(this.buffer.readOnlySlice(), 10);
    }

    @Test
    public void testGetNioBuffer2() {
        this.testGetNioBuffer(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetNioBuffer(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        ByteBuffer sliceByteBuffer = slice.getNioBuffer(1, 1);
        Assert.assertTrue((boolean)sliceByteBuffer.isReadOnly());
        Assert.assertEquals((long)1L, (long)sliceByteBuffer.remaining());
        Assert.assertEquals((long)1L, (long)sliceByteBuffer.limit());
        Assert.assertEquals((long)1L, (long)sliceByteBuffer.capacity());
        sliceByteBuffer.position(1);
        Assert.assertEquals((long)0L, (long)this.buffer.getReaderIndex());
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)this.buffer.getSize());
        Assert.assertEquals((long)sliceSize, (long)slice.getSize());
    }

    @Test
    public void testGetNioBufferReadableThreadSafe1() {
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)this.buffer.readOnlySlice());
    }

    @Test
    public void testGetNioBufferReadableThreadSafe2() {
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)this.buffer.readOnlySlice(1, 2));
    }

    @Test
    public void testGetNioBufferThreadSafe1() {
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)this.buffer.readOnlySlice(), 10);
    }

    @Test
    public void testGetNioBufferThreadSafe2() {
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)this.buffer.readOnlySlice(1, 2), 2);
    }

    @Test
    public void testForwardsSetAllocator() {
        this.testForwardsSetAllocator(this.buffer.readOnlySlice());
        this.testForwardsSetAllocator(this.buffer.readOnlySlice(1, 2));
    }

    private void testForwardsSetAllocator(ReadOnlySlicedNetworkBuffer slice) {
        NettyBufferPool allocator = new NettyBufferPool(1);
        slice.setAllocator((ByteBufAllocator)allocator);
        Assert.assertSame((Object)this.buffer.alloc(), (Object)slice.alloc());
        Assert.assertSame((Object)allocator, (Object)slice.alloc());
    }

    private static void assertReadableBytes(Buffer actualBuffer, int ... expectedBytes) {
        int i;
        ByteBuffer actualBytesBuffer = actualBuffer.getNioBufferReadable();
        int[] actual = new int[actualBytesBuffer.limit()];
        for (int i2 = 0; i2 < actual.length; ++i2) {
            actual[i2] = actualBytesBuffer.get();
        }
        Assert.assertArrayEquals((int[])expectedBytes, (int[])actual);
        ByteBuf buffer = (ByteBuf)actualBuffer;
        for (i = 0; i < buffer.readableBytes(); ++i) {
            actual[i] = buffer.getByte(buffer.readerIndex() + i);
        }
        Assert.assertArrayEquals((int[])expectedBytes, (int[])actual);
        for (i = 0; i < buffer.readableBytes(); ++i) {
            actual[i] = buffer.readByte();
        }
        Assert.assertArrayEquals((int[])expectedBytes, (int[])actual);
    }
}

