/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import java.nio.ByteBuffer;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.InsufficientBufferException;
import org.apache.flink.runtime.io.compression.Lz4BlockCompressionFactory;
import org.junit.Assert;
import org.junit.Test;

public class BlockCompressionTest {
    @Test
    public void testLz4() {
        Lz4BlockCompressionFactory factory = new Lz4BlockCompressionFactory();
        this.runArrayTest((BlockCompressionFactory)factory, 32768);
        this.runArrayTest((BlockCompressionFactory)factory, 16);
        this.runByteBufferTest((BlockCompressionFactory)factory, false, 32768);
        this.runByteBufferTest((BlockCompressionFactory)factory, false, 16);
        this.runByteBufferTest((BlockCompressionFactory)factory, true, 32768);
        this.runByteBufferTest((BlockCompressionFactory)factory, true, 16);
    }

    private void runArrayTest(BlockCompressionFactory factory, int originalLen) {
        BlockCompressor compressor = factory.getCompressor();
        BlockDecompressor decompressor = factory.getDecompressor();
        int originalOff = 64;
        byte[] data = new byte[originalOff + originalLen];
        for (int i = 0; i < originalLen; ++i) {
            data[originalOff + i] = (byte)i;
        }
        int compressedOff = 32;
        byte[] insufficientArray = new byte[compressedOff + 8 + 1];
        try {
            compressor.compress(data, originalOff, originalLen, insufficientArray, compressedOff);
            Assert.fail((String)"expect exception here");
        }
        catch (InsufficientBufferException insufficientBufferException) {
            // empty catch block
        }
        byte[] compressedData = new byte[compressedOff + compressor.getMaxCompressedSize(originalLen)];
        int compressedLen = compressor.compress(data, originalOff, originalLen, compressedData, compressedOff);
        int decompressedOff = 16;
        insufficientArray = new byte[decompressedOff + originalLen - 1];
        try {
            decompressor.decompress(compressedData, compressedOff, compressedLen, insufficientArray, decompressedOff);
            Assert.fail((String)"expect exception here");
        }
        catch (InsufficientBufferException insufficientBufferException) {
            // empty catch block
        }
        byte[] decompressedData = new byte[decompressedOff + originalLen];
        int decompressedLen = decompressor.decompress(compressedData, compressedOff, compressedLen, decompressedData, decompressedOff);
        Assert.assertEquals((long)originalLen, (long)decompressedLen);
        for (int i = 0; i < originalLen; ++i) {
            Assert.assertEquals((long)data[originalOff + i], (long)decompressedData[decompressedOff + i]);
        }
    }

    private void runByteBufferTest(BlockCompressionFactory factory, boolean isDirect, int originalLen) {
        int i;
        BlockCompressor compressor = factory.getCompressor();
        BlockDecompressor decompressor = factory.getDecompressor();
        int originalOff = 64;
        ByteBuffer data = isDirect ? ByteBuffer.allocateDirect(originalOff + originalLen) : ByteBuffer.allocate(originalOff + originalLen);
        for (i = 0; i < originalOff; ++i) {
            data.put((byte)90);
        }
        for (i = 0; i < originalLen; ++i) {
            data.put((byte)i);
        }
        data.flip();
        int maxCompressedLen = compressor.getMaxCompressedSize(originalLen);
        ByteBuffer compressedData = isDirect ? ByteBuffer.allocateDirect(maxCompressedLen) : ByteBuffer.allocate(maxCompressedLen);
        int compressedLen = compressor.compress(data, originalOff, originalLen, compressedData, 0);
        Assert.assertEquals((long)compressedLen, (long)compressedData.position());
        compressedData.flip();
        int compressedOff = 32;
        ByteBuffer copiedCompressedData = isDirect ? ByteBuffer.allocateDirect(compressedOff + compressedLen) : ByteBuffer.allocate(compressedOff + compressedLen);
        for (int i2 = 0; i2 < compressedOff; ++i2) {
            copiedCompressedData.put((byte)90);
        }
        byte[] compressedByteArray = new byte[compressedLen];
        compressedData.get(compressedByteArray, 0, compressedLen);
        copiedCompressedData.put(compressedByteArray);
        copiedCompressedData.flip();
        ByteBuffer decompressedData = isDirect ? ByteBuffer.allocateDirect(originalLen) : ByteBuffer.allocate(originalLen);
        int decompressedLen = decompressor.decompress(copiedCompressedData, compressedOff, compressedLen, decompressedData, 0);
        Assert.assertEquals((long)decompressedLen, (long)decompressedData.position());
        decompressedData.flip();
        for (int i3 = 0; i3 < decompressedLen; ++i3) {
            Assert.assertEquals((long)((byte)i3), (long)decompressedData.get());
        }
    }
}

