/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.JobMasterServiceLeadershipRunnerFactory;
import org.apache.flink.runtime.dispatcher.TestingDispatcher;
import org.apache.flink.runtime.dispatcher.cleanup.CheckpointResourcesCleanupRunnerFactory;
import org.apache.flink.runtime.dispatcher.cleanup.CleanupRunnerFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmanager.StandaloneJobGraphStore;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class AbstractDispatcherTest
extends TestLogger {
    static TestingRpcService rpcService;
    static final Time TIMEOUT;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();
    @Rule
    public TestName name = new TestName();
    Configuration configuration;
    BlobServer blobServer;
    TestingHighAvailabilityServices haServices;
    HeartbeatServices heartbeatServices;

    @BeforeClass
    public static void setupClass() {
        rpcService = new TestingRpcService();
    }

    @AfterClass
    public static void teardownClass() throws Exception {
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService)rpcService, (Time)TIMEOUT);
            rpcService = null;
        }
    }

    static void awaitStatus(DispatcherGateway dispatcherGateway, JobID jobId, JobStatus status) throws Exception {
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> status.equals(dispatcherGateway.requestJobStatus(jobId, TIMEOUT).get())));
    }

    @Before
    public void setUp() throws Exception {
        this.heartbeatServices = new HeartbeatServices(1000L, 10000L);
        this.haServices = new TestingHighAvailabilityServices();
        this.haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        this.haServices.setResourceManagerLeaderRetriever(new SettableLeaderRetrievalService());
        this.haServices.setJobGraphStore((JobGraphStore)new StandaloneJobGraphStore());
        this.haServices.setJobResultStore((JobResultStore)new EmbeddedJobResultStore());
        this.configuration = new Configuration();
        this.blobServer = new BlobServer(this.configuration, this.temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
    }

    protected TestingDispatcher.Builder createTestingDispatcherBuilder() {
        return TestingDispatcher.builder().setConfiguration(this.configuration).setHeartbeatServices(this.heartbeatServices).setHighAvailabilityServices(this.haServices).setJobGraphWriter((JobGraphWriter)this.haServices.getJobGraphStore()).setJobResultStore(this.haServices.getJobResultStore()).setJobManagerRunnerFactory((JobManagerRunnerFactory)JobMasterServiceLeadershipRunnerFactory.INSTANCE).setCleanupRunnerFactory((CleanupRunnerFactory)CheckpointResourcesCleanupRunnerFactory.INSTANCE).setFatalErrorHandler(this.testingFatalErrorHandlerResource.getFatalErrorHandler()).setBlobServer(this.blobServer);
    }

    @After
    public void tearDown() throws Exception {
        if (this.haServices != null) {
            this.haServices.closeAndCleanupAllData();
        }
        if (this.blobServer != null) {
            this.blobServer.close();
        }
    }

    protected BlobServer getBlobServer() {
        return this.blobServer;
    }

    static {
        TIMEOUT = Time.minutes((long)1L);
    }
}

