/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResultPartitionDeploymentDescriptorTest {
    private static final IntermediateDataSetID resultId = new IntermediateDataSetID();
    private static final int numberOfPartitions = 5;
    private static final IntermediateResultPartitionID partitionId = new IntermediateResultPartitionID();
    private static final ExecutionAttemptID producerExecutionId = new ExecutionAttemptID();
    private static final ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
    private static final int numberOfSubpartitions = 24;
    private static final int connectionIndex = 10;
    private static final PartitionDescriptor partitionDescriptor = new PartitionDescriptor(resultId, 5, partitionId, partitionType, 24, 10);
    private static final ResultPartitionID resultPartitionID = new ResultPartitionID(partitionId, producerExecutionId);
    private static final ResourceID producerLocation = new ResourceID("producerLocation");
    private static final InetSocketAddress address = new InetSocketAddress("localhost", 10000);
    private static final ConnectionID connectionID = new ConnectionID(producerLocation, address, 10);

    ResultPartitionDeploymentDescriptorTest() {
    }

    @Test
    void testSerializationOfUnknownShuffleDescriptor() throws IOException {
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(resultPartitionID);
        ShuffleDescriptor shuffleDescriptorCopy = (ShuffleDescriptor)CommonTestUtils.createCopySerializable((Serializable)shuffleDescriptor);
        Assertions.assertThat((Object)shuffleDescriptorCopy).isInstanceOf(UnknownShuffleDescriptor.class);
        Assertions.assertThat((Object)resultPartitionID).isEqualTo((Object)shuffleDescriptorCopy.getResultPartitionID());
        Assertions.assertThat((boolean)shuffleDescriptorCopy.isUnknown()).isTrue();
    }

    @Test
    void testSerializationWithNettyShuffleDescriptor() throws IOException {
        NettyShuffleDescriptor shuffleDescriptor = new NettyShuffleDescriptor(producerLocation, (NettyShuffleDescriptor.PartitionConnectionInfo)new NettyShuffleDescriptor.NetworkPartitionConnectionInfo(address, 10), resultPartitionID);
        ResultPartitionDeploymentDescriptor copy = ResultPartitionDeploymentDescriptorTest.createCopyAndVerifyResultPartitionDeploymentDescriptor((ShuffleDescriptor)shuffleDescriptor);
        Assertions.assertThat((Object)copy.getShuffleDescriptor()).isInstanceOf(NettyShuffleDescriptor.class);
        NettyShuffleDescriptor shuffleDescriptorCopy = (NettyShuffleDescriptor)copy.getShuffleDescriptor();
        Assertions.assertThat((Object)resultPartitionID).isEqualTo((Object)shuffleDescriptorCopy.getResultPartitionID());
        Assertions.assertThat((boolean)shuffleDescriptorCopy.isUnknown()).isFalse();
        Assertions.assertThat((boolean)shuffleDescriptorCopy.isLocalTo(producerLocation)).isTrue();
        Assertions.assertThat((Object)connectionID).isEqualTo((Object)shuffleDescriptorCopy.getConnectionId());
    }

    private static ResultPartitionDeploymentDescriptor createCopyAndVerifyResultPartitionDeploymentDescriptor(ShuffleDescriptor shuffleDescriptor) throws IOException {
        ResultPartitionDeploymentDescriptor orig = new ResultPartitionDeploymentDescriptor(partitionDescriptor, shuffleDescriptor, 24, true);
        ResultPartitionDeploymentDescriptor copy = (ResultPartitionDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
        ResultPartitionDeploymentDescriptorTest.verifyResultPartitionDeploymentDescriptorCopy(copy);
        return copy;
    }

    private static void verifyResultPartitionDeploymentDescriptorCopy(ResultPartitionDeploymentDescriptor copy) {
        Assertions.assertThat((Comparable)resultId).isEqualTo((Object)copy.getResultId());
        Assertions.assertThat((int)5).isEqualTo(copy.getTotalNumberOfPartitions());
        Assertions.assertThat((Object)partitionId).isEqualTo((Object)copy.getPartitionId());
        Assertions.assertThat((Comparable)partitionType).isEqualTo((Object)copy.getPartitionType());
        Assertions.assertThat((int)24).isEqualTo(copy.getNumberOfSubpartitions());
        Assertions.assertThat((boolean)copy.notifyPartitionDataAvailable()).isTrue();
    }
}

