/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.junit.Assert;
import org.junit.Test;

public class FailedCheckpointStatsTest {
    @Test
    public void testEndToEndDuration() throws Exception {
        long duration = 123912931293L;
        long triggerTimestamp = 10123L;
        long failureTimestamp = triggerTimestamp + duration;
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        FailedCheckpointStats failed = new FailedCheckpointStats(0L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 0, 0L, 0L, 0L, 0L, failureTimestamp, null, null);
        Assert.assertEquals((long)duration, (long)failed.getEndToEndDuration());
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        long duration = 123912931293L;
        long triggerTimestamp = 10123L;
        long failureTimestamp = triggerTimestamp + duration;
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        FailedCheckpointStats failed = new FailedCheckpointStats(123123123L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats, 3, 190890123L, 190890123L, 4242L, 4444L, failureTimestamp, null, (Throwable)new NotSerializableException("message"));
        FailedCheckpointStats copy = (FailedCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)failed);
        Assert.assertEquals((long)failed.getCheckpointId(), (long)copy.getCheckpointId());
        Assert.assertEquals((long)failed.getTriggerTimestamp(), (long)copy.getTriggerTimestamp());
        Assert.assertEquals((Object)failed.getProperties(), (Object)copy.getProperties());
        Assert.assertEquals((long)failed.getNumberOfSubtasks(), (long)copy.getNumberOfSubtasks());
        Assert.assertEquals((long)failed.getNumberOfAcknowledgedSubtasks(), (long)copy.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)failed.getEndToEndDuration(), (long)copy.getEndToEndDuration());
        Assert.assertEquals((long)failed.getStateSize(), (long)copy.getStateSize());
        Assert.assertEquals((long)failed.getProcessedData(), (long)copy.getProcessedData());
        Assert.assertEquals((long)failed.getPersistedData(), (long)copy.getPersistedData());
        Assert.assertEquals((Object)failed.getLatestAcknowledgedSubtaskStats(), (Object)copy.getLatestAcknowledgedSubtaskStats());
        Assert.assertEquals((Object)failed.getStatus(), (Object)copy.getStatus());
        Assert.assertEquals((Object)failed.getFailureMessage(), (Object)copy.getFailureMessage());
    }
}

