/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.operators.AllReduceProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.operators.ReduceProperties;
import org.apache.flink.runtime.operators.DriverStrategy;

public class ReduceNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;
    private ReduceNode preReduceUtilityNode;

    public ReduceNode(ReduceOperatorBase<?, ?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        OperatorDescriptorSingle props;
        if (this.keys == null) {
            this.setParallelism(1);
        }
        if (this.keys == null) {
            props = new AllReduceProperties();
        } else {
            DriverStrategy combinerStrategy;
            switch (operator.getCombineHint()) {
                case OPTIMIZER_CHOOSES: {
                    combinerStrategy = DriverStrategy.SORTED_PARTIAL_REDUCE;
                    break;
                }
                case SORT: {
                    combinerStrategy = DriverStrategy.SORTED_PARTIAL_REDUCE;
                    break;
                }
                case HASH: {
                    combinerStrategy = DriverStrategy.HASHED_PARTIAL_REDUCE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown CombineHint");
                }
            }
            props = new ReduceProperties(this.keys, operator.getCustomPartitioner(), combinerStrategy);
        }
        this.possibleProperties = Collections.singletonList(props);
    }

    public ReduceNode(ReduceNode reducerToCopyForCombiner) {
        super(reducerToCopyForCombiner);
        this.possibleProperties = Collections.emptyList();
    }

    public ReduceOperatorBase<?, ?> getOperator() {
        return (ReduceOperatorBase)super.getOperator();
    }

    @Override
    public String getOperatorName() {
        return "Reduce";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    public ReduceNode getCombinerUtilityNode() {
        if (this.preReduceUtilityNode == null) {
            this.preReduceUtilityNode = new ReduceNode(this);
            this.preReduceUtilityNode.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
            this.preReduceUtilityNode.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        }
        return this.preReduceUtilityNode;
    }
}

