/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;
import org.apache.flink.api.java.summarize.aggregation.NumericSummaryAggregator;

@Internal
public class DoubleSummaryAggregator
extends NumericSummaryAggregator<Double> {
    @Override
    protected Aggregator<Double, Double> initMin() {
        return new MinDoubleAggregator();
    }

    @Override
    protected Aggregator<Double, Double> initMax() {
        return new MaxDoubleAggregator();
    }

    @Override
    protected Aggregator<Double, Double> initSum() {
        return new SumDoubleAggregator();
    }

    @Override
    protected boolean isNan(Double number) {
        return number.isNaN();
    }

    @Override
    protected boolean isInfinite(Double number) {
        return number.isInfinite();
    }

    public static class SumDoubleAggregator
    implements Aggregator<Double, Double> {
        private CompensatedSum sum = CompensatedSum.ZERO;

        @Override
        public void aggregate(Double value) {
            this.sum = this.sum.add(value);
        }

        @Override
        public void combine(Aggregator<Double, Double> other) {
            this.sum = this.sum.add(((SumDoubleAggregator)other).sum);
        }

        @Override
        public Double result() {
            return this.sum.value();
        }
    }

    public static class MaxDoubleAggregator
    implements Aggregator<Double, Double> {
        private double max = Double.NEGATIVE_INFINITY;

        @Override
        public void aggregate(Double value) {
            this.max = Math.max(this.max, value);
        }

        @Override
        public void combine(Aggregator<Double, Double> other) {
            this.max = Math.max(this.max, ((MaxDoubleAggregator)other).max);
        }

        @Override
        public Double result() {
            return this.max;
        }
    }

    public static class MinDoubleAggregator
    implements Aggregator<Double, Double> {
        private double min = Double.POSITIVE_INFINITY;

        @Override
        public void aggregate(Double value) {
            this.min = Math.min(this.min, value);
        }

        @Override
        public void combine(Aggregator<Double, Double> other) {
            this.min = Math.min(this.min, ((MinDoubleAggregator)other).min);
        }

        @Override
        public Double result() {
            return this.min;
        }
    }
}

