/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DeltaIterationResultSet;
import org.apache.flink.types.Value;
import org.apache.flink.util.Preconditions;

@Public
public class DeltaIteration<ST, WT> {
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private final DataSet<ST> initialSolutionSet;
    private final DataSet<WT> initialWorkset;
    private final SolutionSetPlaceHolder<ST> solutionSetPlaceholder;
    private final WorksetPlaceHolder<WT> worksetPlaceholder;
    private final Keys<ST> keys;
    private final int maxIterations;
    private String name;
    private int parallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    private boolean solutionSetUnManaged;

    public DeltaIteration(ExecutionEnvironment context, TypeInformation<ST> type, DataSet<ST> solutionSet, DataSet<WT> workset, Keys<ST> keys, int maxIterations) {
        this.initialSolutionSet = solutionSet;
        this.initialWorkset = workset;
        this.solutionSetPlaceholder = new SolutionSetPlaceHolder(context, solutionSet.getType(), this);
        this.worksetPlaceholder = new WorksetPlaceHolder(context, workset.getType());
        this.keys = keys;
        this.maxIterations = maxIterations;
    }

    public DataSet<ST> closeWith(DataSet<ST> solutionSetDelta, DataSet<WT> newWorkset) {
        return new DeltaIterationResultSet<ST, WT>(this.initialSolutionSet.getExecutionEnvironment(), this.initialSolutionSet.getType(), this.initialWorkset.getType(), this, solutionSetDelta, newWorkset, this.keys, this.maxIterations);
    }

    public DataSet<ST> getInitialSolutionSet() {
        return this.initialSolutionSet;
    }

    public DataSet<WT> getInitialWorkset() {
        return this.initialWorkset;
    }

    public SolutionSetPlaceHolder<ST> getSolutionSet() {
        return this.solutionSetPlaceholder;
    }

    public WorksetPlaceHolder<WT> getWorkset() {
        return this.worksetPlaceholder;
    }

    public DeltaIteration<ST, WT> name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DeltaIteration<ST, WT> parallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be positive, or ExecutionConfig.PARALLELISM_DEFAULT (use default).");
        this.parallelism = parallelism;
        return this;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    private DeltaIteration<ST, WT> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        Preconditions.checkNotNull((Object)minResources, (String)"The min resources must be not null.");
        Preconditions.checkNotNull((Object)preferredResources, (String)"The preferred resources must be not null.");
        Preconditions.checkArgument((minResources.isValid() && preferredResources.isValid() && minResources.lessThanOrEqual(preferredResources) ? 1 : 0) != 0, (Object)"The values in resources must be not less than 0 and the preferred resources must be greater than the min resources.");
        this.minResources = minResources;
        this.preferredResources = preferredResources;
        return this;
    }

    private DeltaIteration<ST, WT> setResources(ResourceSpec resources) {
        Preconditions.checkNotNull((Object)resources, (String)"The resources must be not null.");
        Preconditions.checkArgument((boolean)resources.isValid(), (Object)"The values in resources must be not less than 0.");
        this.minResources = resources;
        this.preferredResources = resources;
        return this;
    }

    @PublicEvolving
    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    @PublicEvolving
    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    @PublicEvolving
    public DeltaIteration<ST, WT> registerAggregator(String name, Aggregator<?> aggregator) {
        this.aggregators.registerAggregator(name, aggregator);
        return this;
    }

    @PublicEvolving
    public <X extends Value> DeltaIteration<ST, WT> registerAggregationConvergenceCriterion(String name, Aggregator<X> aggregator, ConvergenceCriterion<X> convergenceCheck) {
        this.aggregators.registerAggregationConvergenceCriterion(name, aggregator, convergenceCheck);
        return this;
    }

    @PublicEvolving
    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    public void setSolutionSetUnManaged(boolean solutionSetUnManaged) {
        this.solutionSetUnManaged = solutionSetUnManaged;
    }

    public boolean isSolutionSetUnManaged() {
        return this.solutionSetUnManaged;
    }

    @Public
    public static class WorksetPlaceHolder<WT>
    extends DataSet<WT> {
        private WorksetPlaceHolder(ExecutionEnvironment context, TypeInformation<WT> type) {
            super(context, type);
        }
    }

    @Public
    public static class SolutionSetPlaceHolder<ST>
    extends DataSet<ST> {
        private final DeltaIteration<ST, ?> deltaIteration;

        private SolutionSetPlaceHolder(ExecutionEnvironment context, TypeInformation<ST> type, DeltaIteration<ST, ?> deltaIteration) {
            super(context, type);
            this.deltaIteration = deltaIteration;
        }

        public void checkJoinKeyFields(int[] keyFields) {
            int[] ssKeys = ((DeltaIteration)this.deltaIteration).keys.computeLogicalKeyPositions();
            if (!Arrays.equals(ssKeys, keyFields)) {
                throw new InvalidProgramException("The solution can only be joined/co-grouped with the same keys as the elements are identified with (here: " + Arrays.toString(ssKeys) + ").");
            }
        }
    }
}

