/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.table.converter.RowDataToBsonConverters;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.SerializableFunction;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoShardKeysExtractor
implements SerializableFunction<RowData, BsonDocument> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MongoShardKeysExtractor.class);
    private static final BsonDocument EMPTY_DOCUMENT = new BsonDocument();
    private final SerializableFunction<Object, BsonValue> shardKeysConverter;
    private final RowData.FieldGetter shardKeysGetter;

    private MongoShardKeysExtractor(LogicalType shardKeysType, int[] shardKeysIndexes) {
        this.shardKeysConverter = RowDataToBsonConverters.createFieldDataConverter(shardKeysType);
        this.shardKeysGetter = (RowData.FieldGetter & Serializable)rowData -> ProjectedRowData.from((int[])shardKeysIndexes).replaceRow(rowData);
    }

    public BsonDocument apply(RowData rowData) {
        BsonDocument shardKeysDoc = Optional.ofNullable(this.shardKeysGetter.getFieldOrNull(rowData)).map(shardKeys -> ((BsonValue)this.shardKeysConverter.apply(shardKeys)).asDocument()).orElse(EMPTY_DOCUMENT);
        shardKeysDoc.entrySet().forEach(entry -> {
            String keyString;
            if (((BsonValue)entry.getValue()).isString() && ObjectId.isValid((String)(keyString = ((BsonValue)entry.getValue()).asString().getValue()))) {
                entry.setValue(new BsonObjectId(new ObjectId(keyString)));
            }
        });
        return shardKeysDoc;
    }

    public static SerializableFunction<RowData, BsonDocument> createShardKeysExtractor(ResolvedSchema resolvedSchema, String[] shardKeys) {
        if (shardKeys.length == 0) {
            return new NoOpShardKeysExtractor();
        }
        int[] shardKeysIndexes = MongoShardKeysExtractor.getShardKeysIndexes(resolvedSchema.getColumnNames(), shardKeys);
        DataType physicalRowDataType = resolvedSchema.toPhysicalRowDataType();
        DataType shardKeysType = Projection.of((int[])shardKeysIndexes).project(physicalRowDataType);
        MongoShardKeysExtractor shardKeysExtractor = new MongoShardKeysExtractor(shardKeysType.getLogicalType(), shardKeysIndexes);
        LOG.info("Shard keys extractor created, shard keys: {}", (Object)Arrays.toString(shardKeys));
        return shardKeysExtractor;
    }

    private static int[] getShardKeysIndexes(List<String> columnNames, String[] shardKeys) {
        return Arrays.stream(shardKeys).mapToInt(columnNames::indexOf).toArray();
    }

    private static class NoOpShardKeysExtractor
    implements SerializableFunction<RowData, BsonDocument> {
        private static final long serialVersionUID = 1L;

        private NoOpShardKeysExtractor() {
        }

        public BsonDocument apply(RowData rowData) {
            return EMPTY_DOCUMENT;
        }
    }
}

