/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.mongodb.common.utils.MongoConstants;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSingleSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitContext;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoSampleSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSampleSplitter.class);

    public static Collection<MongoScanSourceSplit> split(MongoSplitContext splitContext) {
        return MongoSampleSplitter.split(splitContext, new DefaultMongoSampler());
    }

    @VisibleForTesting
    static Collection<MongoScanSourceSplit> split(MongoSplitContext splitContext, BiFunction<MongoSplitContext, Integer, List<BsonDocument>> sampler) {
        MongoReadOptions readOptions = splitContext.getReadOptions();
        MongoNamespace namespace = splitContext.getMongoNamespace();
        long totalNumDocuments = splitContext.getCount();
        long partitionSizeInBytes = readOptions.getPartitionSize().getBytes();
        int samplesPerPartition = readOptions.getSamplesPerPartition();
        long avgObjSizeInBytes = splitContext.getAvgObjSize();
        if (avgObjSizeInBytes == 0L) {
            LOG.info("{} seems to be an empty collection, Returning a single partition.", (Object)namespace);
            return MongoSingleSplitter.split(splitContext);
        }
        long numDocumentsPerPartition = partitionSizeInBytes / avgObjSizeInBytes;
        if (numDocumentsPerPartition >= totalNumDocuments) {
            LOG.info("Fewer documents ({}) than the number of documents per partition ({}), Returning a single partition.", (Object)totalNumDocuments, (Object)numDocumentsPerPartition);
            return MongoSingleSplitter.split(splitContext);
        }
        int numberOfPartitions = (int)Math.ceil((double)totalNumDocuments * 1.0 / (double)numDocumentsPerPartition);
        int numberOfSamples = samplesPerPartition * numberOfPartitions - 1;
        List<BsonDocument> samples = sampler.apply(splitContext, numberOfSamples);
        return MongoSampleSplitter.createSplits(samples, samplesPerPartition, namespace);
    }

    @VisibleForTesting
    static List<MongoScanSourceSplit> createSplits(List<BsonDocument> samples, int samplesPerPartition, MongoNamespace namespace) {
        samples.add(MongoConstants.BSON_MAX_BOUNDARY);
        ArrayList<MongoScanSourceSplit> sourceSplits = new ArrayList<MongoScanSourceSplit>();
        BsonDocument partitionStart = MongoConstants.BSON_MIN_BOUNDARY;
        int splitNum = 0;
        for (int i = samplesPerPartition - 1; i < samples.size(); i += samplesPerPartition) {
            sourceSplits.add(MongoSampleSplitter.createSplit(namespace, splitNum++, partitionStart, samples.get(i)));
            partitionStart = samples.get(i);
        }
        return sourceSplits;
    }

    private static MongoScanSourceSplit createSplit(MongoNamespace ns, int index, BsonDocument min, BsonDocument max) {
        return new MongoScanSourceSplit(String.format("%s_%d", ns, index), ns.getDatabaseName(), ns.getCollectionName(), min, max, MongoConstants.ID_HINT);
    }

    private static class DefaultMongoSampler
    implements BiFunction<MongoSplitContext, Integer, List<BsonDocument>> {
        private DefaultMongoSampler() {
        }

        @Override
        public List<BsonDocument> apply(MongoSplitContext splitContext, Integer numberOfSamples) {
            return (List)splitContext.getMongoCollection().aggregate(Arrays.asList(Aggregates.sample((int)numberOfSamples), Aggregates.project((Bson)Projections.include((String[])new String[]{"_id"})), Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{"_id"})))).allowDiskUse(Boolean.valueOf(true)).into(new ArrayList());
        }
    }
}

