/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.source.MongoSource;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.table.MongoConnectorOptions;
import org.apache.flink.connector.mongodb.table.MongoRowDataLookupFunction;
import org.apache.flink.connector.mongodb.table.serialization.MongoRowDataDeserializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class MongoDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown {
    private final MongoConnectionOptions connectionOptions;
    private final MongoReadOptions readOptions;
    @Nullable
    private final LookupCache lookupCache;
    private final int lookupMaxRetries;
    private final long lookupRetryIntervalMs;
    private DataType producedDataType;
    private int limit = -1;

    public MongoDynamicTableSource(MongoConnectionOptions connectionOptions, MongoReadOptions readOptions, @Nullable LookupCache lookupCache, int lookupMaxRetries, long lookupRetryIntervalMs, DataType producedDataType) {
        this.connectionOptions = connectionOptions;
        this.readOptions = readOptions;
        this.lookupCache = lookupCache;
        Preconditions.checkArgument((lookupMaxRetries >= 0 ? 1 : 0) != 0, (Object)String.format("The '%s' must be larger than or equal to 0.", LookupOptions.MAX_RETRIES.key()));
        Preconditions.checkArgument((lookupRetryIntervalMs > 0L ? 1 : 0) != 0, (Object)String.format("The '%s' must be larger than 0.", MongoConnectorOptions.LOOKUP_RETRY_INTERVAL.key()));
        this.lookupMaxRetries = lookupMaxRetries;
        this.lookupRetryIntervalMs = lookupRetryIntervalMs;
        this.producedDataType = producedDataType;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        ArrayList<String> keyNames = new ArrayList<String>(context.getKeys().length);
        for (int[] innerKeyArr : context.getKeys()) {
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"MongoDB only support non-nested look up keys yet");
            keyNames.add((String)DataType.getFieldNames((DataType)this.producedDataType).get(innerKeyArr[0]));
        }
        RowType rowType = (RowType)this.producedDataType.getLogicalType();
        MongoRowDataLookupFunction lookupFunction = new MongoRowDataLookupFunction(this.connectionOptions, this.lookupMaxRetries, this.lookupRetryIntervalMs, DataType.getFieldNames((DataType)this.producedDataType), DataType.getFieldDataTypes((DataType)this.producedDataType), keyNames, rowType);
        if (this.lookupCache != null) {
            return PartialCachingLookupProvider.of((LookupFunction)lookupFunction, (LookupCache)this.lookupCache);
        }
        return LookupFunctionProvider.of((LookupFunction)lookupFunction);
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        RowType rowType = (RowType)this.producedDataType.getLogicalType();
        TypeInformation typeInfo = runtimeProviderContext.createTypeInformation(this.producedDataType);
        MongoRowDataDeserializationSchema deserializationSchema = new MongoRowDataDeserializationSchema(rowType, (TypeInformation<RowData>)typeInfo);
        MongoSource<RowData> mongoSource = MongoSource.builder().setUri(this.connectionOptions.getUri()).setDatabase(this.connectionOptions.getDatabase()).setCollection(this.connectionOptions.getCollection()).setFetchSize(this.readOptions.getFetchSize()).setNoCursorTimeout(this.readOptions.isNoCursorTimeout()).setPartitionStrategy(this.readOptions.getPartitionStrategy()).setPartitionSize(this.readOptions.getPartitionSize()).setSamplesPerPartition(this.readOptions.getSamplesPerPartition()).setLimit(this.limit).setProjectedFields(DataType.getFieldNames((DataType)this.producedDataType)).setDeserializationSchema(deserializationSchema).build();
        return SourceProvider.of(mongoSource);
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSource copy() {
        return new MongoDynamicTableSource(this.connectionOptions, this.readOptions, this.lookupCache, this.lookupMaxRetries, this.lookupRetryIntervalMs, this.producedDataType);
    }

    public String asSummaryString() {
        return "MongoDB";
    }

    public void applyLimit(long limit) {
        this.limit = (int)limit;
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.producedDataType = producedDataType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MongoDynamicTableSource)) {
            return false;
        }
        MongoDynamicTableSource that = (MongoDynamicTableSource)o;
        return Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.readOptions, that.readOptions) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.limit, that.limit) && Objects.equals(this.lookupCache, that.lookupCache) && Objects.equals(this.lookupMaxRetries, that.lookupMaxRetries) && Objects.equals(this.lookupRetryIntervalMs, that.lookupRetryIntervalMs);
    }

    public int hashCode() {
        return Objects.hash(this.connectionOptions, this.readOptions, this.producedDataType, this.limit, this.lookupCache, this.lookupMaxRetries, this.lookupRetryIntervalMs);
    }
}

