/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.common.utils;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoValidationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MongoValidationUtils.class);
    public static final Set<LogicalTypeRoot> ALLOWED_PRIMARY_KEY_TYPES = EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME});
    private static final Set<LogicalTypeRoot> DENIED_PRIMARY_KEY_TYPES = EnumSet.of(LogicalTypeRoot.BINARY, new LogicalTypeRoot[]{LogicalTypeRoot.VARBINARY, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED});

    public static void validatePrimaryKey(DataType primaryKeyDataType) {
        List fieldDataTypes = DataType.getFieldDataTypes((DataType)primaryKeyDataType);
        ArrayList<DataType> illegalTypes = new ArrayList<DataType>();
        for (DataType fieldType : fieldDataTypes) {
            LogicalTypeRoot typeRoot = fieldType.getLogicalType().getTypeRoot();
            if (ALLOWED_PRIMARY_KEY_TYPES.contains(typeRoot)) continue;
            illegalTypes.add(fieldType);
            if (DENIED_PRIMARY_KEY_TYPES.contains(typeRoot)) continue;
            LOG.warn("Detected newly added root type {} that should to be explicitly accepted or rejected. Please reach out to the Flink maintainers.", (Object)fieldType);
        }
        if (!illegalTypes.isEmpty()) {
            throw new ValidationException(String.format("The table has a primary key on columns of illegal types: %s. Allowed types are %s.", illegalTypes, ALLOWED_PRIMARY_KEY_TYPES));
        }
    }

    private MongoValidationUtils() {
    }
}

