/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import org.apache.flink.annotation.Internal;

@Internal
public class TransactionalIdFactory {
    private static final String TRANSACTIONAL_ID_DELIMITER = "-";

    public static String buildTransactionalId(String transactionalIdPrefix, int subtaskId, long checkpointOffset) {
        return transactionalIdPrefix + TRANSACTIONAL_ID_DELIMITER + subtaskId + TRANSACTIONAL_ID_DELIMITER + checkpointOffset;
    }

    public static int extractSubtaskId(String name) {
        int lastSep = name.lastIndexOf(TRANSACTIONAL_ID_DELIMITER);
        int secondLastSep = name.lastIndexOf(TRANSACTIONAL_ID_DELIMITER, lastSep - 1);
        String subtaskString = name.substring(secondLastSep + 1, lastSep);
        return Integer.parseInt(subtaskString);
    }

    public static String extractPrefix(String name) {
        int lastSep = name.lastIndexOf(TRANSACTIONAL_ID_DELIMITER);
        int secondLastSep = name.lastIndexOf(TRANSACTIONAL_ID_DELIMITER, lastSep - 1);
        return name.substring(0, secondLastSep);
    }
}

