/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.lineage;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.kafka.lineage.KafkaDatasetIdentifier;

@PublicEvolving
public class DefaultKafkaDatasetIdentifier
implements KafkaDatasetIdentifier {
    @Nullable
    private final List<String> topics;
    @Nullable
    private final Pattern topicPattern;

    private DefaultKafkaDatasetIdentifier(@Nullable List<String> fixedTopics, @Nullable Pattern topicPattern) {
        this.topics = fixedTopics;
        this.topicPattern = topicPattern;
    }

    public static DefaultKafkaDatasetIdentifier ofPattern(Pattern pattern) {
        return new DefaultKafkaDatasetIdentifier(null, pattern);
    }

    public static DefaultKafkaDatasetIdentifier ofTopics(List<String> fixedTopics) {
        return new DefaultKafkaDatasetIdentifier(fixedTopics, null);
    }

    @Override
    @Nullable
    public List<String> getTopics() {
        return this.topics;
    }

    @Override
    @Nullable
    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKafkaDatasetIdentifier that = (DefaultKafkaDatasetIdentifier)o;
        return Objects.equals(this.topics, that.topics) && Objects.equals(this.topicPattern, that.topicPattern);
    }

    public int hashCode() {
        return Objects.hash(this.topics, this.topicPattern);
    }
}

