/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
class ElasticsearchValidationUtils {
    private static final Set<LogicalTypeRoot> ALLOWED_PRIMARY_KEY_TYPES = new LinkedHashSet<LogicalTypeRoot>();

    public static void validatePrimaryKey(DataType primaryKeyDataType) {
        List fieldDataTypes = DataType.getFieldDataTypes((DataType)primaryKeyDataType);
        List illegalTypes = fieldDataTypes.stream().map(DataType::getLogicalType).map(logicalType -> {
            if (logicalType.is(LogicalTypeRoot.DISTINCT_TYPE)) {
                return ((DistinctType)logicalType).getSourceType().getTypeRoot();
            }
            return logicalType.getTypeRoot();
        }).filter(t -> !ALLOWED_PRIMARY_KEY_TYPES.contains(t)).collect(Collectors.toList());
        if (!illegalTypes.isEmpty()) {
            throw new ValidationException(String.format("The table has a primary key on columns of illegal types: %s.", illegalTypes));
        }
    }

    private ElasticsearchValidationUtils() {
    }

    static {
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.CHAR);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.VARCHAR);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.BOOLEAN);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.DECIMAL);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.TINYINT);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.SMALLINT);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.INTEGER);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.BIGINT);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.FLOAT);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.DOUBLE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.DATE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.INTERVAL_YEAR_MONTH);
        ALLOWED_PRIMARY_KEY_TYPES.add(LogicalTypeRoot.INTERVAL_DAY_TIME);
    }
}

