/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.ContextEnvironmentFactory;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;

public class ContextEnvironment
extends ExecutionEnvironment {
    protected final Client client;
    protected final List<URL> jarFilesToAttach;
    protected final List<URL> classpathsToAttach;
    protected final ClassLoader userCodeClassLoader;
    protected final String savepointPath;

    public ContextEnvironment(Client remoteConnection, List<URL> jarFiles, List<URL> classpaths, ClassLoader userCodeClassLoader, String savepointPath) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.classpathsToAttach = classpaths;
        this.userCodeClassLoader = userCodeClassLoader;
        this.savepointPath = savepointPath;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        Plan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars(p, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader);
        this.lastJobExecutionResult = this.client.runBlocking(toRun, this.getParallelism(), this.savepointPath);
        return this.lastJobExecutionResult;
    }

    public String getExecutionPlan() throws Exception {
        Plan plan = this.createProgramPlan("unnamed job");
        OptimizedPlan op = Client.getOptimizedPlan(this.client.compiler, plan, this.getParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public void startNewSession() throws Exception {
        this.client.endSession(this.jobID);
        this.jobID = JobID.generate();
    }

    public String toString() {
        return "Context Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    public Client getClient() {
        return this.client;
    }

    public List<URL> getJars() {
        return this.jarFilesToAttach;
    }

    public List<URL> getClasspaths() {
        return this.classpathsToAttach;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public String getSavepointPath() {
        return this.savepointPath;
    }

    static void setAsContext(ContextEnvironmentFactory factory) {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    static void unsetContext() {
        ContextEnvironment.resetContextEnvironment();
    }
}

