/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.MessageLite;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufAttachmentUtils;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufUtils;
import org.apache.dubbo.common.serialize.protobuf.support.wrapper.MapValue;

public class GenericProtobufObjectOutput
implements ObjectOutput {
    private final OutputStream os;

    public GenericProtobufObjectOutput(OutputStream os) {
        this.os = os;
    }

    public void writeBool(boolean v) throws IOException {
        this.writeObject(BoolValue.newBuilder().setValue(v).build());
    }

    public void writeByte(byte v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    public void writeShort(short v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue((int)v).build());
    }

    public void writeInt(int v) throws IOException {
        this.writeObject(Int32Value.newBuilder().setValue(v).build());
    }

    public void writeLong(long v) throws IOException {
        this.writeObject(Int64Value.newBuilder().setValue(v).build());
    }

    public void writeFloat(float v) throws IOException {
        this.writeObject(FloatValue.newBuilder().setValue(v).build());
    }

    public void writeDouble(double v) throws IOException {
        this.writeObject(DoubleValue.newBuilder().setValue(v).build());
    }

    public void writeUTF(String v) throws IOException {
        this.writeObject(StringValue.newBuilder().setValue(v).build());
    }

    public void writeBytes(byte[] b) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b)).build());
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writeObject(BytesValue.newBuilder().setValue(ByteString.copyFrom((byte[])b, (int)off, (int)len)).build());
    }

    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            throw new IllegalStateException("This serialization only supports google protobuf objects, please use com.google.protobuf.Empty instead if you want to transmit null values.");
        }
        if (!ProtobufUtils.isSupported(obj.getClass())) {
            throw new IllegalArgumentException("This serialization only supports google protobuf objects, current object class is: " + obj.getClass().getName());
        }
        ProtobufUtils.serialize(obj, this.os);
        this.os.flush();
    }

    public void writeEvent(Object data) throws IOException {
        if (data == CommonConstants.HEARTBEAT_EVENT) {
            data = "H";
        }
        this.writeUTF((String)data);
    }

    public void writeThrowable(Object obj) throws IOException {
        if (obj instanceof Throwable && !(obj instanceof MessageLite)) {
            obj = ProtobufUtils.convertToThrowableProto((Throwable)obj);
        }
        ProtobufUtils.serialize(obj, this.os);
        this.os.flush();
    }

    public void writeAttachments(Map<String, Object> attachments) throws IOException {
        if (attachments == null) {
            return;
        }
        MapValue.Map map = ProtobufAttachmentUtils.wrap(attachments);
        ProtobufUtils.serialize(map, this.os);
        this.os.flush();
    }

    public void flushBuffer() throws IOException {
        this.os.flush();
    }
}

