/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model.key;

import io.micrometer.common.lang.Nullable;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsKeyWrapper {
    private final MetricsKey metricsKey;
    private final MetricsPlaceValue placeType;
    private MetricSample.Type sampleType = MetricSample.Type.COUNTER;

    public MetricsKeyWrapper(MetricsKey metricsKey, @Nullable MetricsPlaceValue placeType) {
        this.metricsKey = metricsKey;
        this.placeType = placeType;
    }

    public MetricsKeyWrapper setSampleType(MetricSample.Type sampleType) {
        this.sampleType = sampleType;
        return this;
    }

    public MetricSample.Type getSampleType() {
        return this.sampleType;
    }

    public MetricsPlaceValue getPlaceType() {
        return this.placeType;
    }

    public String getType() {
        return this.getPlaceType().getType();
    }

    public MetricsKey getMetricsKey() {
        return this.metricsKey;
    }

    public boolean isKey(MetricsKey metricsKey, String registryOpType) {
        return metricsKey == this.getMetricsKey() && registryOpType.equals(this.getType());
    }

    public MetricsLevel getLevel() {
        return this.getPlaceType().getMetricsLevel();
    }

    public String targetKey() {
        if (this.placeType == null) {
            return this.metricsKey.getName();
        }
        try {
            return String.format(this.metricsKey.getName(), this.getType());
        }
        catch (Exception ignore) {
            return this.metricsKey.getName();
        }
    }

    public String targetDesc() {
        if (this.placeType == null) {
            return this.metricsKey.getDescription();
        }
        try {
            return String.format(this.metricsKey.getDescription(), this.getType());
        }
        catch (Exception ignore) {
            return this.metricsKey.getDescription();
        }
    }

    public Map<String, String> tagName(ApplicationModel applicationModel, String key) {
        MetricsLevel level = this.getLevel();
        switch (level) {
            case APP: {
                return MetricsSupport.applicationTags(applicationModel);
            }
            case SERVICE: {
                return MetricsSupport.serviceTags(applicationModel, key);
            }
            case METHOD: {
                return MetricsSupport.methodTags(applicationModel, key);
            }
        }
        return MetricsSupport.applicationTags(applicationModel);
    }

    public static MetricsKeyWrapper wrapper(MetricsKey metricsKey) {
        return new MetricsKeyWrapper(metricsKey, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsKeyWrapper wrapper = (MetricsKeyWrapper)o;
        if (this.metricsKey != wrapper.metricsKey) {
            return false;
        }
        return Objects.equals(this.placeType, wrapper.placeType);
    }

    public int hashCode() {
        int result = this.metricsKey != null ? this.metricsKey.hashCode() : 0;
        result = 31 * result + (this.placeType != null ? this.placeType.hashCode() : 0);
        return result;
    }
}

