/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceKeyMetric
extends ApplicationMetric {
    private final String interfaceName;

    public ServiceKeyMetric(ApplicationModel applicationModel, String serviceKey) {
        super(applicationModel);
        this.interfaceName = serviceKey;
    }

    @Override
    public Map<String, String> getTags() {
        return MetricsSupport.serviceTags(this.getApplicationModel(), this.interfaceName);
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKeyMetric that = (ServiceKeyMetric)o;
        if (!this.getApplicationName().equals(that.getApplicationName())) {
            return false;
        }
        return this.interfaceName.equals(that.interfaceName);
    }

    public int hashCode() {
        int result = this.getApplicationName().hashCode();
        result = 31 * result + this.interfaceName.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceKeyMetric{applicationName='" + this.getApplicationName() + '\'' + ", serviceKey='" + this.interfaceName + '\'' + '}';
    }
}

