/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MethodMetric
extends ServiceKeyMetric {
    private String side;
    private final String methodName;
    private String group;
    private String version;
    private final MetricSample.Type sampleType;

    public MethodMetric(ApplicationModel applicationModel, Invocation invocation) {
        super(applicationModel, MetricsSupport.getInterfaceName(invocation));
        this.methodName = RpcUtils.getMethodName((Invocation)invocation);
        this.side = MetricsSupport.getSide(invocation);
        this.group = MetricsSupport.getGroup(invocation);
        this.version = MetricsSupport.getVersion(invocation);
        this.sampleType = (MetricSample.Type)((Object)invocation.get((Object)"metric_filter_invocation_counter"));
    }

    public MetricSample.Type getSampleType() {
        return this.sampleType;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Map<String, String> getTags() {
        Map<String, String> tags = MetricsSupport.methodTags(this.getApplicationModel(), this.getInterfaceName(), this.methodName);
        tags.put("group", this.group);
        tags.put("version", this.version);
        return tags;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    @Override
    public String toString() {
        return "MethodMetric{applicationName='" + this.getApplicationName() + '\'' + ", side='" + this.side + '\'' + ", interfaceName='" + this.getInterfaceName() + '\'' + ", methodName='" + this.methodName + '\'' + ", group='" + this.group + '\'' + ", version='" + this.version + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMetric that = (MethodMetric)o;
        return Objects.equals(this.getApplicationName(), that.getApplicationName()) && Objects.equals(this.side, that.side) && Objects.equals(this.getInterfaceName(), that.getInterfaceName()) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getApplicationName(), this.side, this.getInterfaceName(), this.methodName, this.group, this.version);
    }
}

