/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class MetricsEvent {
    protected transient ApplicationModel source;
    private boolean available = true;
    private final TypeWrapper typeWrapper;
    private final Map<String, Object> attachment = new HashMap<String, Object>(8);

    public MetricsEvent(ApplicationModel source, TypeWrapper typeWrapper) {
        this.typeWrapper = typeWrapper;
        if (source == null) {
            this.source = ApplicationModel.defaultModel();
            this.available = false;
        } else {
            this.source = source;
        }
    }

    public <T> T getAttachmentValue(String key) {
        if (key == null) {
            throw new MetricsNeverHappenException("Attachment key is null");
        }
        return (T)this.attachment.get(key);
    }

    public void putAttachment(String key, Object value) {
        this.attachment.put(key, value);
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void customAfterPost(Object postResult) {
    }

    public ApplicationModel getSource() {
        return this.source;
    }

    public String appName() {
        return this.getSource().getApplicationName();
    }

    public TypeWrapper getTypeWrapper() {
        return this.typeWrapper;
    }

    public boolean isAssignableFrom(Object type) {
        return this.typeWrapper.isAssignableFrom(type);
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "]";
    }

    public static enum Type {
        TOTAL("TOTAL_%s"),
        SUCCEED("SUCCEED_%s"),
        BUSINESS_FAILED("BUSINESS_FAILED_%s"),
        REQUEST_TIMEOUT("REQUEST_TIMEOUT_%s"),
        REQUEST_LIMIT("REQUEST_LIMIT_%s"),
        PROCESSING("PROCESSING_%s"),
        UNKNOWN_FAILED("UNKNOWN_FAILED_%s"),
        TOTAL_FAILED("TOTAL_FAILED_%s"),
        APPLICATION_INFO("APPLICATION_INFO_%s"),
        NETWORK_EXCEPTION("NETWORK_EXCEPTION_%s"),
        SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE_%s"),
        CODEC_EXCEPTION("CODEC_EXCEPTION_%s"),
        NO_INVOKER_AVAILABLE("NO_INVOKER_AVAILABLE_%s");

        private final String name;

        public final String getName() {
            return this.name;
        }

        public final String getNameByType(String type) {
            return String.format(this.name, type);
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

