/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public class ClusterUtils {
    private ClusterUtils() {
    }

    public static URL mergeUrl(URL remoteUrl, Map<String, String> localMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map remoteMap = remoteUrl.getParameters();
        if (remoteMap != null && remoteMap.size() > 0) {
            map.putAll(remoteMap);
            map.remove("threadname");
            map.remove("default.threadname");
            map.remove("threadpool");
            map.remove("default.threadpool");
            map.remove("corethreads");
            map.remove("default.corethreads");
            map.remove("threads");
            map.remove("default.threads");
            map.remove("queues");
            map.remove("default.queues");
            map.remove("alive");
            map.remove("default.alive");
            map.remove("transporter");
            map.remove("default.transporter");
        }
        if (localMap != null && localMap.size() > 0) {
            String remoteGroup = (String)map.get("group");
            String remoteRelease = (String)map.get("release");
            map.putAll(localMap);
            if (StringUtils.isNotEmpty((String)remoteGroup)) {
                map.put("group", remoteGroup);
            }
            map.remove("release");
            if (StringUtils.isNotEmpty((String)remoteRelease)) {
                map.put("release", remoteRelease);
            }
        }
        if (remoteMap != null && remoteMap.size() > 0) {
            ClusterUtils.reserveRemoteValue("dubbo", map, remoteMap);
            ClusterUtils.reserveRemoteValue("version", map, remoteMap);
            ClusterUtils.reserveRemoteValue("methods", map, remoteMap);
            ClusterUtils.reserveRemoteValue("timestamp", map, remoteMap);
            ClusterUtils.reserveRemoteValue("dubbo.tag", map, remoteMap);
            map.put("remote.application", (String)remoteMap.get("application"));
            String remoteFilter = (String)remoteMap.get("reference.filter");
            String localFilter = localMap.get("reference.filter");
            if (remoteFilter != null && remoteFilter.length() > 0 && localFilter != null && localFilter.length() > 0) {
                localMap.put("reference.filter", remoteFilter + "," + localFilter);
            }
            String remoteListener = (String)remoteMap.get("invoker.listener");
            String localListener = localMap.get("invoker.listener");
            if (remoteListener != null && remoteListener.length() > 0 && localListener != null && localListener.length() > 0) {
                localMap.put("invoker.listener", remoteListener + "," + localListener);
            }
        }
        return remoteUrl.clearParameters().addParameters(map);
    }

    private static void reserveRemoteValue(String key, Map<String, String> map, Map<String, String> remoteMap) {
        String remoteValue = remoteMap.get(key);
        if (StringUtils.isNotEmpty((String)remoteValue)) {
            map.put(key, remoteValue);
        }
    }
}

