/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.shared.ldap.aci.ACIItemChecker;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACIItemSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ACIItemSyntaxChecker.class);
    private static final long serialVersionUID = 1L;
    private static final ACIItemChecker ACI_ITEM_CHECKER = new ACIItemChecker();

    public ACIItemSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            ACIItemChecker aCIItemChecker = ACI_ITEM_CHECKER;
            synchronized (aCIItemChecker) {
                ACI_ITEM_CHECKER.parse(strValue);
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

