/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentifierNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public ObjectIdentifierNormalizer() {
        super("2.5.13.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        String str = value.getString().trim();
        if (str.length() == 0) {
            return new ClientStringValue("");
        }
        if (Character.isDigit(str.charAt(0))) {
            return new ClientStringValue(str);
        }
        return new ClientStringValue(str.toLowerCase());
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return "";
        }
        if (Character.isDigit(str.charAt(0))) {
            return str;
        }
        return str.toLowerCase();
    }
}

