/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueMemberComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueMemberComparator.class);
    private static final long serialVersionUID = 1L;
    private transient SchemaManager schemaManager;

    public UniqueMemberComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String dnstr0, String dnstr1) {
        int dash0 = dnstr0.lastIndexOf(35);
        int dash1 = dnstr1.lastIndexOf(35);
        if (dash0 == -1 && dash1 == -1) {
            try {
                return this.getDn(dnstr0).compareTo(this.getDn(dnstr1));
            }
            catch (NamingException ne) {
                return -1;
            }
        }
        if (dnstr0.indexOf(35) != dash0) {
            return -1;
        }
        if (dnstr1.indexOf(35) != dash0) {
            return 1;
        }
        DN dn0 = null;
        DN dn1 = null;
        String uid0 = dnstr0.substring(dash0 + 1);
        if (dash0 > 0) {
            try {
                dn0 = new DN(dnstr0.substring(0, dash0));
            }
            catch (NamingException ne) {
                return -1;
            }
        } else {
            return -1;
        }
        String uid1 = dnstr1.substring(dash1 + 1);
        if (dash1 > 0) {
            try {
                dn1 = new DN(dnstr0.substring(0, dash1));
            }
            catch (NamingException ne) {
                return 1;
            }
        } else {
            return 1;
        }
        int dnComp = dn0.compareTo(dn1);
        if (dnComp != 0) {
            return dnComp;
        }
        return uid0.compareTo(uid1);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public DN getDn(Object obj) throws NamingException {
        DN dn = null;
        if (obj instanceof DN) {
            dn = (DN)obj;
            dn = dn.isNormalized() ? dn : DN.normalize(dn, this.schemaManager.getNormalizerMapping());
        } else if (obj instanceof Name) {
            dn = new DN((Name)obj);
            dn.normalize(this.schemaManager.getNormalizerMapping());
        } else if (obj instanceof String) {
            dn = new DN((String)obj);
            dn.normalize(this.schemaManager.getNormalizerMapping());
        } else {
            throw new IllegalStateException(I18n.err((String)"ERR_04218", (Object[])new Object[]{obj == null ? null : obj.getClass()}));
        }
        return dn;
    }
}

