/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.filter.BranchNormalizedVisitor;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponse;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchResponseDone;
import org.apache.directory.shared.ldap.name.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestImpl
extends AbstractAbandonableRequest
implements InternalSearchRequest {
    static final long serialVersionUID = -5655881944020886218L;
    private DN baseDn;
    private ExprNode filter;
    private SearchScope scope;
    private boolean typesOnly;
    private long sizeLimit;
    private int timeLimit;
    private AliasDerefMode aliasDerefMode;
    private List<String> attributes = new ArrayList<String>();
    private InternalSearchResponseDone response;

    public SearchRequestImpl(int id) {
        super(id, MessageTypeEnum.SEARCH_REQUEST);
    }

    @Override
    public List<String> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public DN getBase() {
        return this.baseDn;
    }

    @Override
    public void setBase(DN base) {
        this.baseDn = base;
    }

    @Override
    public AliasDerefMode getDerefAliases() {
        return this.aliasDerefMode;
    }

    @Override
    public void setDerefAliases(AliasDerefMode aliasDerefAliases) {
        this.aliasDerefMode = aliasDerefAliases;
    }

    @Override
    public ExprNode getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    @Override
    public MessageTypeEnum[] getResponseTypes() {
        return (MessageTypeEnum[])RESPONSE_TYPES.clone();
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    @Override
    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    @Override
    public long getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public void setSizeLimit(long entriesMax) {
        this.sizeLimit = entriesMax;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(int secondsMax) {
        this.timeLimit = secondsMax;
    }

    @Override
    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    @Override
    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    @Override
    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new SearchResponseDoneImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSearchRequest req = (InternalSearchRequest)obj;
        if (!req.getBase().equals(this.baseDn)) {
            return false;
        }
        if (req.getDerefAliases() != this.aliasDerefMode) {
            return false;
        }
        if (req.getScope() != this.scope) {
            return false;
        }
        if (req.getSizeLimit() != this.sizeLimit) {
            return false;
        }
        if (req.getTimeLimit() != this.timeLimit) {
            return false;
        }
        if (req.getTypesOnly() != this.typesOnly) {
            return false;
        }
        if (req.getAttributes() == null && this.attributes != null && this.attributes.size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes == null && req.getAttributes().size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes != null) {
            if (req.getAttributes().size() != this.attributes.size()) {
                return false;
            }
            Iterator<String> list = this.attributes.iterator();
            while (list.hasNext()) {
                if (req.getAttributes().contains(list.next())) continue;
                return false;
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        req.getFilter().accept(visitor);
        this.filter.accept(visitor);
        String myFilterString = this.filter.toString();
        String reqFilterString = req.getFilter().toString();
        return myFilterString.equals(reqFilterString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SearchRequest\n");
        sb.append("        baseDn : '").append(this.baseDn).append("'\n");
        if (this.filter != null) {
            sb.append("        filter : '");
            sb.append(this.filter.toString());
            sb.append("'\n");
        }
        sb.append("        scope : ");
        switch (this.scope) {
            case OBJECT: {
                sb.append("base object");
                break;
            }
            case ONELEVEL: {
                sb.append("single level");
                break;
            }
            case SUBTREE: {
                sb.append("whole subtree");
            }
        }
        sb.append('\n');
        sb.append("        typesOnly : ").append(this.typesOnly).append('\n');
        sb.append("        Size Limit : ");
        if (this.sizeLimit == 0L) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append('\n');
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append('\n');
        sb.append("        Deref Aliases : ");
        switch (this.aliasDerefMode.getValue()) {
            case 0: {
                sb.append("never Deref Aliases");
                break;
            }
            case 1: {
                sb.append("deref In Searching");
                break;
            }
            case 2: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case 3: {
                sb.append("deref Always");
            }
        }
        sb.append('\n');
        sb.append("        attributes : ");
        boolean isFirst = true;
        if (this.attributes != null) {
            Iterator<String> it = this.attributes.iterator();
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append(it.next()).append('\'');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

