/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseNameAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ResponseNameAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ResponseNameAction() {
        super("Store response name");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        ExtendedResponseCodec extendedResponse = ldapMessageContainer.getExtendedResponse();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            log.error(I18n.err((String)"ERR_04017", (Object[])new Object[0]));
            throw new DecoderException(I18n.err((String)"ERR_04017", (Object[])new Object[0]));
        }
        extendedResponse.setResponseName(new OID(StringTools.asciiBytesToString(tlv.getValue().getData())));
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("OID read : {}", (Object)extendedResponse.getResponseName());
        }
    }
}

