/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.controls.CodecControl;
import org.apache.directory.shared.ldap.codec.controls.ControlDecoder;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ControlValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        LdapMessageCodec message = ldapMessageContainer.getLdapMessage();
        Control control = message.getCurrentControl();
        Value value = tlv.getValue();
        ControlDecoder decoder = ((CodecControl)((Object)control)).getDecoder();
        if (tlv.getLength() == 0) {
            control.setValue(StringTools.EMPTY_BYTES);
        } else if (decoder == null) {
            control.setValue(value.getData());
        } else {
            decoder.decode(value.getData(), control);
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("Control value : " + StringTools.dumpBytes(control.getValue()));
        }
    }
}

