/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.DecoderMonitor;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.RuntimeMultiException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderDecoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDecoder
implements ProviderDecoder {
    private static Logger log = LoggerFactory.getLogger(LdapDecoder.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Provider provider;
    private final LdapMessageContainer ldapMessageContainer;
    private final Asn1Decoder ldapDecoder;
    private DecoderCallback decoderCallback;

    public LdapDecoder(Provider provider, BinaryAttributeDetector binaryAttributeDetector, int maxPDUSize) {
        this.provider = provider;
        this.ldapMessageContainer = new LdapMessageContainer(binaryAttributeDetector);
        this.ldapDecoder = new Asn1Decoder();
        this.ldapMessageContainer.setMaxPDUSize(maxPDUSize);
    }

    public void decode(Object encoded) throws DecoderException {
        ByteBuffer buf;
        int position = 0;
        if (encoded instanceof ByteBuffer) {
            buf = (ByteBuffer)encoded;
        } else if (encoded instanceof byte[]) {
            buf = ByteBuffer.wrap((byte[])encoded);
        } else {
            throw new DecoderException(I18n.err((String)"ERR_04059", (Object[])new Object[]{encoded.getClass()}));
        }
        while (buf.hasRemaining()) {
            try {
                this.ldapDecoder.decode(buf, (IAsn1Container)this.ldapMessageContainer);
                if (IS_DEBUG) {
                    log.debug("Decoding the PDU : ");
                    int size = buf.position();
                    buf.flip();
                    byte[] array = new byte[size - position];
                    for (int i = position; i < size; ++i) {
                        array[i] = buf.get();
                    }
                    position = size;
                    log.debug(StringTools.dumpBytes(array));
                }
                if (this.ldapMessageContainer.getState() != 1024) continue;
                if (IS_DEBUG) {
                    log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
                    buf.mark();
                }
                this.decoderCallback.decodeOccurred(null, (Object)this.ldapMessageContainer.getLdapMessage());
                this.ldapMessageContainer.clean();
            }
            catch (DecoderException de) {
                buf.clear();
                this.ldapMessageContainer.clean();
                throw de;
            }
        }
    }

    private void digest(InputStream in) throws ProviderException {
        try {
            byte[] buf;
            int amount;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.ldapDecoder.decode(ByteBuffer.wrap(buf, 0, amount), (IAsn1Container)this.ldapMessageContainer);
            }
        }
        catch (Exception e) {
            log.error(I18n.err((String)"ERR_04060", (Object[])new Object[]{e.getLocalizedMessage()}));
            ProviderException pe = new ProviderException(this.provider, I18n.err((String)"ERR_04061", (Object[])new Object[0]));
            pe.addThrowable(e);
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws ProviderException {
        Object pe2;
        if (lock == null) {
            this.digest(in);
            if (this.ldapMessageContainer.getState() == 1024) {
                if (IS_DEBUG) {
                    log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
                }
                return this.ldapMessageContainer.getLdapMessage();
            }
            log.error(I18n.err((String)"ERR_04062", (Object[])new Object[0]));
            ProviderException pe2 = new ProviderException(this.provider, I18n.err((String)"ERR_04061", (Object[])new Object[0]));
            pe2.addThrowable(new DecoderException(I18n.err((String)"ERR_04063", (Object[])new Object[0])));
            throw pe2;
        }
        try {
            pe2 = lock;
            synchronized (pe2) {
                this.digest(in);
                lock.notifyAll();
            }
        }
        catch (Exception e) {
            log.error(I18n.err((String)"ERR_04060", (Object[])new Object[]{e.getLocalizedMessage()}));
            ProviderException pe3 = new ProviderException(this.provider, I18n.err((String)"ERR_04061", (Object[])new Object[0]));
            pe3.addThrowable(e);
            throw pe3;
        }
        if (this.ldapMessageContainer.getState() == 1024) {
            if (IS_DEBUG) {
                log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
            }
            return this.ldapMessageContainer.getLdapMessage();
        }
        log.error(I18n.err((String)"ERR_04064", (Object[])new Object[0]));
        pe2 = new ProviderException(this.provider, I18n.err((String)"ERR_04062", (Object[])new Object[0]));
        ((RuntimeMultiException)pe2).addThrowable(new DecoderException(I18n.err((String)"ERR_04063", (Object[])new Object[0])));
        throw pe2;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
    }

    public void setCallback(DecoderCallback cb) {
        this.decoderCallback = cb;
    }
}

