/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C> {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurableImpl.class);
    private static final Class<?>[] RESTRICTED_CLASSES_IN_SERVER = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class};
    private static final Class<?>[] RESTRICTED_CLASSES_IN_CLIENT = new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class};
    private ConfigurationImpl config;
    private final C configurable;
    private final Class<?>[] restrictedContractTypes;

    public ConfigurableImpl(C configurable, RuntimeType rt) {
        this(configurable, new ConfigurationImpl(rt));
    }

    public ConfigurableImpl(C configurable, Configuration config) {
        this.configurable = configurable;
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config);
        this.restrictedContractTypes = RuntimeType.CLIENT.equals((Object)config.getRuntimeType()) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER;
    }

    static Class<?>[] getImplementedContracts(Object provider, Class<?>[] restrictedClasses) {
        Class<?> providerClass = provider instanceof Class ? (Class<?>)provider : provider.getClass();
        Set<Class<?>> interfaces = ConfigurableImpl.collectAllInterfaces(providerClass);
        List<Class> implementedContracts = interfaces.stream().filter(el -> Arrays.stream(restrictedClasses).noneMatch(el::equals)).collect(Collectors.toList());
        return implementedContracts.toArray(new Class[0]);
    }

    private static Set<Class<?>> collectAllInterfaces(Class<?> providerClass) {
        HashSet interfaces = new HashSet();
        do {
            for (Class<?> anInterface : providerClass.getInterfaces()) {
                ConfigurableImpl.collectInterfaces(interfaces, anInterface);
            }
        } while ((providerClass = providerClass.getSuperclass()) != null && providerClass != Object.class);
        return interfaces;
    }

    private static void collectInterfaces(Set<Class<?>> interfaces, Class<?> anInterface) {
        interfaces.add(anInterface);
        for (Class<?> superInterface : anInterface.getInterfaces()) {
            ConfigurableImpl.collectInterfaces(interfaces, superInterface);
        }
    }

    protected C getConfigurable() {
        return this.configurable;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public C property(String name, Object value) {
        this.config.setProperty(name, value);
        return this.configurable;
    }

    public C register(Object provider) {
        return this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
    }

    public C register(Object provider, int bindingPriority) {
        return this.doRegister(provider, bindingPriority, ConfigurableImpl.getImplementedContracts(provider, this.restrictedContractTypes));
    }

    public C register(Object provider, Class<?> ... contracts) {
        return this.doRegister(provider, 5000, contracts);
    }

    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        return this.doRegister(provider, contracts);
    }

    public C register(Class<?> providerClass) {
        return this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
    }

    public C register(Class<?> providerClass, int bindingPriority) {
        return this.doRegister(this.getInstantiator().create(providerClass), bindingPriority, ConfigurableImpl.getImplementedContracts(providerClass, this.restrictedContractTypes));
    }

    public C register(Class<?> providerClass, Class<?> ... contracts) {
        return this.doRegister(providerClass, 5000, contracts);
    }

    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        return this.register(this.getInstantiator().create(providerClass), contracts);
    }

    protected Instantiator getInstantiator() {
        return ConfigurationImpl::createProvider;
    }

    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LOG.warning("Null, empty or invalid contracts specified for " + provider + "; ignoring.");
            return this.configurable;
        }
        return this.doRegister(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
    }

    private C doRegister(Object provider, Map<Class<?>, Integer> contracts) {
        if (!this.checkConstraints(provider)) {
            return this.configurable;
        }
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            return this.configurable;
        }
        this.config.register(provider, contracts);
        return this.configurable;
    }

    private boolean checkConstraints(Object provider) {
        Class<?> providerClass = provider.getClass();
        ConstrainedTo providerConstraint = providerClass.getAnnotation(ConstrainedTo.class);
        if (providerConstraint != null) {
            Class<?>[] restrictedInterfaces;
            RuntimeType currentRuntime = this.config.getRuntimeType();
            RuntimeType providerRuntime = providerConstraint.value();
            if (!providerRuntime.equals((Object)currentRuntime)) {
                LOG.warning("Provider " + provider + " cannot be registered in this " + currentRuntime + " runtime because it is constrained to " + providerRuntime + " runtimes.");
                return false;
            }
            for (Class<?> restrictedContract : restrictedInterfaces = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER) {
                if (!restrictedContract.isAssignableFrom(providerClass)) continue;
                RuntimeType opposite = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RuntimeType.SERVER : RuntimeType.CLIENT;
                LOG.warning("Provider " + providerClass.getName() + " is invalid - it is constrained to " + providerRuntime + " runtimes but implements a " + opposite + " interface ");
                return false;
            }
        }
        return true;
    }

    public static interface Instantiator {
        public <T> Object create(Class<T> var1);
    }
}

