/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class StringTextProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<String>,
MessageBodyWriter<String> {
    private int bufferSize = 4096;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return String.class == type;
    }

    public String readFrom(Class<String> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        return IOUtils.toString((InputStream)is, (String)HttpUtils.getEncoding(mt, "UTF-8"));
    }

    public long getSize(String t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return String.class == type;
    }

    public void writeTo(String obj, Class<?> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String encoding = HttpUtils.getSetEncoding(mt, headers, "UTF-8");
        byte[] bytes = obj.getBytes(encoding);
        if (bytes.length > this.bufferSize) {
            int bl;
            for (int pos = 0; pos < bytes.length; pos += bl) {
                bl = bytes.length - pos;
                if (bl > this.bufferSize) {
                    bl = this.bufferSize;
                }
                os.write(bytes, pos, bl);
            }
        } else {
            os.write(bytes);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

