/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wsdl2js;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.cxf.maven_plugin.wsdl2js.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOption
extends Option
implements GenericWsdlOption {
    private String wsdl;
    private WsdlArtifact artifact;

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public WsdlArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public void setArtifact(WsdlArtifact artifact) {
        this.artifact = artifact;
    }

    @Override
    public String getUri() {
        return this.wsdl;
    }

    @Override
    public void setUri(String uri) {
        this.wsdl = uri;
    }

    @Override
    public File[] getDeleteDirs() {
        return new File[0];
    }

    @Override
    public List<String> generateCommandLine(File outputDirFile, URI basedir, URI wsdlURI, boolean debug) {
        ArrayList<String> options = new ArrayList<String>();
        if (this.wsdlVersion != null && !"".equals(this.wsdlVersion)) {
            options.add("-wv");
            options.add(this.wsdlVersion);
        }
        if (this.packagePrefixes != null) {
            for (Option.UriPrefixPair upp : this.packagePrefixes) {
                options.add("-p");
                options.add(String.format("%s=%s", upp.getPrefix(), upp.getUri()));
            }
        }
        if (this.catalog != null && !"".equals(this.catalog)) {
            options.add("-catalog");
            options.add(this.catalog.getAbsolutePath());
        }
        options.add("-d");
        if (this.output != null) {
            options.add(this.output.getAbsolutePath());
        } else {
            options.add(outputDirFile.getAbsolutePath());
        }
        if (this.validate != null && this.validate.booleanValue()) {
            options.add("-validate");
        }
        if (debug) {
            options.add("-v");
            options.add("-V");
        }
        options.add(this.wsdl);
        return options;
    }

    @Override
    public String toString() {
        return String.format("WsdlOption [wsdl=%s, artifact=%s, %s]", this.wsdl, this.artifact, super.toString());
    }
}

