/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.common.security.SimpleSecurityContext;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosAuthenticationFilter
implements RequestHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(KerberosAuthenticationFilter.class);
    private static final String NEGOTIATE_SCHEME = "Negotiate";
    private static final String PROPERTY_USE_KERBEROS_OID = "auth.spnego.useKerberosOid";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private MessageContext messageContext;
    private CallbackHandler callbackHandler;
    private Configuration loginConfig;
    private String loginContextName = "";
    private String servicePrincipalName;
    private String realm;

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        List authHeaders = this.messageContext.getHttpHeaders().getRequestHeader("Authorization");
        if (authHeaders.size() != 1) {
            LOG.fine("No Authorization header is available");
            throw ExceptionUtils.toNotAuthorizedException(null, KerberosAuthenticationFilter.getFaultResponse());
        }
        String[] authPair = StringUtils.split((String)authHeaders.get(0), " ");
        if (authPair.length != 2 || !NEGOTIATE_SCHEME.equalsIgnoreCase(authPair[0])) {
            LOG.fine("Negotiate Authorization scheme is expected");
            throw ExceptionUtils.toNotAuthorizedException(null, KerberosAuthenticationFilter.getFaultResponse());
        }
        byte[] serviceTicket = this.getServiceTicket(authPair[1]);
        try {
            Subject serviceSubject = this.loginAndGetSubject();
            GSSContext gssContext = this.createGSSContext();
            Subject.doAs(serviceSubject, new ValidateServiceTicketAction(gssContext, serviceTicket));
            GSSName srcName = gssContext.getSrcName();
            if (srcName == null) {
                throw ExceptionUtils.toNotAuthorizedException(null, KerberosAuthenticationFilter.getFaultResponse());
            }
            String complexUserName = srcName.toString();
            String simpleUserName = complexUserName;
            int index = simpleUserName.lastIndexOf(64);
            if (index > 0) {
                simpleUserName = simpleUserName.substring(0, index);
            }
            if (!gssContext.getCredDelegState()) {
                gssContext.dispose();
                gssContext = null;
            }
            m.put(SecurityContext.class, new KerberosSecurityContext(new KerberosPrincipal(simpleUserName, complexUserName), gssContext));
        }
        catch (LoginException e) {
            LOG.fine("Unsuccessful JAAS login for the service principal: " + e.getMessage());
            throw ExceptionUtils.toNotAuthorizedException(e, KerberosAuthenticationFilter.getFaultResponse());
        }
        catch (GSSException e) {
            LOG.fine("GSS API exception: " + e.getMessage());
            throw ExceptionUtils.toNotAuthorizedException(e, KerberosAuthenticationFilter.getFaultResponse());
        }
        catch (PrivilegedActionException e) {
            LOG.fine("PrivilegedActionException: " + e.getMessage());
            throw ExceptionUtils.toNotAuthorizedException(e, KerberosAuthenticationFilter.getFaultResponse());
        }
        return null;
    }

    protected GSSContext createGSSContext() throws GSSException {
        boolean useKerberosOid = MessageUtils.isTrue(this.messageContext.getContextualProperty(PROPERTY_USE_KERBEROS_OID));
        Oid oid = new Oid(useKerberosOid ? KERBEROS_OID : SPNEGO_OID);
        GSSManager gssManager = GSSManager.getInstance();
        String spn = this.getCompleteServicePrincipalName();
        GSSName gssService = gssManager.createName(spn, null);
        return gssManager.createContext(gssService.canonicalize(oid), oid, null, 0);
    }

    protected Subject loginAndGetSubject() throws LoginException {
        LoginContext lc = null;
        if (StringUtils.isEmpty(this.loginContextName) && this.loginConfig == null) {
            LOG.fine("LoginContext can not be initialized");
            throw new LoginException();
        }
        lc = new LoginContext(this.loginContextName, null, this.callbackHandler, this.loginConfig);
        lc.login();
        return lc.getSubject();
    }

    private byte[] getServiceTicket(String encodedServiceTicket) {
        try {
            return Base64Utility.decode(encodedServiceTicket);
        }
        catch (Base64Exception ex) {
            throw ExceptionUtils.toNotAuthorizedException(null, KerberosAuthenticationFilter.getFaultResponse());
        }
    }

    private static Response getFaultResponse() {
        return JAXRSUtils.toResponseBuilder(401).header("WWW-Authenticate", (Object)NEGOTIATE_SCHEME).build();
    }

    protected String getCompleteServicePrincipalName() {
        String name;
        String string = name = this.servicePrincipalName == null ? "HTTP/" + this.messageContext.getUriInfo().getBaseUri().getHost() : this.servicePrincipalName;
        if (this.realm != null) {
            name = name + "@" + this.realm;
        }
        return name;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.messageContext = context;
    }

    public void setLoginContextName(String contextName) {
        this.loginContextName = contextName;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public static class KerberosSecurityContext
    extends SimpleSecurityContext {
        private GSSContext context;

        public KerberosSecurityContext(KerberosPrincipal principal, GSSContext context) {
            super(principal);
            this.context = context;
        }

        public GSSContext getGSSContext() {
            return this.context;
        }
    }

    public static class KerberosPrincipal
    extends SimplePrincipal {
        private String complexName;

        public KerberosPrincipal(String simpleName, String complexName) {
            super(simpleName);
            this.complexName = complexName;
        }

        public String getKerberosName() {
            return this.complexName;
        }
    }

    private final class ValidateServiceTicketAction
    implements PrivilegedExceptionAction<byte[]> {
        private final GSSContext context;
        private final byte[] token;

        private ValidateServiceTicketAction(GSSContext context, byte[] token) {
            this.context = context;
            this.token = token;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.context.acceptSecContext(this.token, 0, this.token.length);
        }
    }
}

