/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

public class StringParser {
    private static final int UCHAR_LEN = 4;
    private static final int SHIFT = 12;
    private static final int BASE10 = 10;
    private static final char LAST_ASCII = '\u007f';

    public static String buildString(CharSequence str, boolean eatsep) {
        StringBuilder strb = new StringBuilder(str.length());
        char sep = eatsep ? str.charAt(0) : (char)'\u0000';
        int end = str.length() - (eatsep ? 1 : 0);
        int begin = eatsep ? 1 : 0;
        StringParser.read(strb, str, begin, end, sep);
        return strb.toString();
    }

    public static int readString(StringBuilder strb, CharSequence str, int index, char sep) {
        return StringParser.read(strb, str, index, str.length(), sep);
    }

    private static int read(StringBuilder strb, CharSequence str, int begin, int end, char sep) {
        int index;
        boolean escape = false;
        for (index = begin; index < end; ++index) {
            char c = str.charAt(index);
            if (escape) {
                if (c == 'u' && index + 4 < end && StringParser.readUnicodeChar(strb, str, index + 1) > 0) {
                    index += 4;
                } else {
                    boolean notSeparator;
                    boolean bl = sep == '\u0000' ? c != '\'' && c != '\"' : (notSeparator = c != sep);
                    if (notSeparator && c != '\\') {
                        strb.append('\\');
                    }
                    strb.append(c);
                }
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            strb.append(c);
            if (c == sep) break;
        }
        return index;
    }

    private static int readUnicodeChar(StringBuilder strb, CharSequence str, int begin) {
        char xc = '\u0000';
        int bits = 12;
        int value = 0;
        for (int offset = 0; offset < 4; ++offset) {
            char c = str.charAt(begin + offset);
            if (c >= '0' && c <= '9') {
                value = c - 48;
            } else if (c >= 'a' && c <= 'h') {
                value = c - 97 + 10;
            } else if (c >= 'A' && c <= 'H') {
                value = c - 65 + 10;
            } else {
                return 0;
            }
            xc = (char)(xc | value << bits);
            bits -= 4;
        }
        strb.append(xc);
        return 4;
    }

    public static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder strb = new StringBuilder(length + 2);
        strb.append('\'');
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c < '\u007f') {
                if (c == '\'') {
                    strb.append('\\');
                    strb.append('\'');
                    continue;
                }
                if (c == '\\') {
                    strb.append('\\');
                    strb.append('\\');
                    continue;
                }
                strb.append(c);
                continue;
            }
            strb.append('\\');
            strb.append('u');
            String hex = Integer.toHexString(c);
            for (int h = hex.length(); h < 4; ++h) {
                strb.append('0');
            }
            strb.append(hex);
        }
        strb.append('\'');
        return strb.toString();
    }
}

