/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class KeyCount
implements TBase<KeyCount, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("KeyCount");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField COUNT_FIELD_DESC = new TField("count", 8, 2);
    public ByteBuffer key;
    public int count;
    private static final int __COUNT_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public KeyCount() {
    }

    public KeyCount(ByteBuffer key, int count) {
        this();
        this.key = key;
        this.count = count;
        this.setCountIsSet(true);
    }

    public KeyCount(KeyCount other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetKey()) {
            this.key = TBaseHelper.copyBinary((ByteBuffer)other.key);
        }
        this.count = other.count;
    }

    public KeyCount deepCopy() {
        return new KeyCount(this);
    }

    public void clear() {
        this.key = null;
        this.setCountIsSet(false);
        this.count = 0;
    }

    public byte[] getKey() {
        this.setKey(TBaseHelper.rightSize((ByteBuffer)this.key));
        return this.key == null ? null : this.key.array();
    }

    public ByteBuffer bufferForKey() {
        return this.key;
    }

    public KeyCount setKey(byte[] key) {
        this.setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
        return this;
    }

    public KeyCount setKey(ByteBuffer key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public int getCount() {
        return this.count;
    }

    public KeyCount setCount(int count) {
        this.count = count;
        this.setCountIsSet(true);
        return this;
    }

    public void unsetCount() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetCount() {
        return this.__isset_bit_vector.get(0);
    }

    public void setCountIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((ByteBuffer)value);
                break;
            }
            case COUNT: {
                if (value == null) {
                    this.unsetCount();
                    break;
                }
                this.setCount((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case COUNT: {
                return new Integer(this.getCount());
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case COUNT: {
                return this.isSetCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof KeyCount) {
            return this.equals((KeyCount)that);
        }
        return false;
    }

    public boolean equals(KeyCount that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_count = true;
        boolean that_present_count = true;
        if (this_present_count || that_present_count) {
            if (!this_present_count || !that_present_count) {
                return false;
            }
            if (this.count != that.count) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append((Object)this.key);
        }
        boolean present_count = true;
        builder.append(present_count);
        if (present_count) {
            builder.append(this.count);
        }
        return builder.toHashCode();
    }

    public int compareTo(KeyCount other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        KeyCount typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)typedOther.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCount()).compareTo(typedOther.isSetCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCount() && (lastComparison = TBaseHelper.compareTo((int)this.count, (int)typedOther.count)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.key = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.count = iprot.readI32();
                        this.setCountIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetCount()) {
            throw new TProtocolException("Required field 'count' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            oprot.writeFieldBegin(KEY_FIELD_DESC);
            oprot.writeBinary(this.key);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(COUNT_FIELD_DESC);
        oprot.writeI32(this.count);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyCount(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.key, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("count:");
        sb.append(this.count);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key == null) {
            throw new TProtocolException("Required field 'key' was not present! Struct: " + this.toString());
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COUNT, new FieldMetaData("count", 1, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(KeyCount.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        COUNT(2, "count");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return COUNT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

