/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CassandraVersion
implements Comparable<CassandraVersion> {
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)(?:\\.(\\w+))?(?:\\.(\\w+))?(\\-[-.\\w]+)?([.+][.\\w]+)?";
    private static final Pattern PATTERN_WORDS = Pattern.compile("\\w+");
    @VisibleForTesting
    static final int NO_HOTFIX = -1;
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\w+))?(?:\\.(\\w+))?(\\-[-.\\w]+)?([.+][.\\w]+)?");
    public static final CassandraVersion CASSANDRA_4_0 = new CassandraVersion((String)"4.0").familyLowerBound.get();
    public static final CassandraVersion CASSANDRA_4_0_RC2 = new CassandraVersion(4, 0, 0, -1, new String[]{"rc2"}, null);
    public static final CassandraVersion CASSANDRA_3_4 = new CassandraVersion((String)"3.4").familyLowerBound.get();
    public final int major;
    public final int minor;
    public final int patch;
    public final int hotfix;
    public final Supplier<CassandraVersion> familyLowerBound = Suppliers.memoize(this::getFamilyLowerBound);
    private final String[] preRelease;
    private final String[] build;

    @VisibleForTesting
    CassandraVersion(int major, int minor, int patch, int hotfix, String[] preRelease, String[] build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.hotfix = hotfix;
        this.preRelease = preRelease;
        this.build = build;
    }

    public CassandraVersion(String version) {
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version value: " + version);
        }
        try {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.patch = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
            this.hotfix = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : -1;
            String pr = matcher.group(5);
            String bld = matcher.group(6);
            this.preRelease = pr == null || pr.isEmpty() ? null : CassandraVersion.parseIdentifiers(version, pr);
            this.build = bld == null || bld.isEmpty() ? null : CassandraVersion.parseIdentifiers(version, bld);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version value: " + version, e);
        }
    }

    private CassandraVersion getFamilyLowerBound() {
        return this.patch == 0 && this.hotfix == -1 && this.preRelease != null && this.preRelease.length == 0 && this.build == null ? this : new CassandraVersion(this.major, this.minor, 0, -1, ArrayUtils.EMPTY_STRING_ARRAY, null);
    }

    private static String[] parseIdentifiers(String version, String str) {
        String[] parts;
        str = str.substring(1);
        for (String part : parts = StringUtils.split((String)str, (String)".-")) {
            if (PATTERN_WORDS.matcher(part).matches()) continue;
            throw new IllegalArgumentException("Invalid version value: " + version + "; " + part + " not a valid identifier");
        }
        return parts;
    }

    public List<String> getPreRelease() {
        return this.preRelease != null ? Arrays.asList(this.preRelease) : Collections.emptyList();
    }

    public List<String> getBuild() {
        return this.build != null ? Arrays.asList(this.build) : Collections.emptyList();
    }

    @Override
    public int compareTo(CassandraVersion other) {
        return this.compareTo(other, false);
    }

    public int compareTo(CassandraVersion other, boolean compareToPatchOnly) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (compareToPatchOnly) {
            return 0;
        }
        int c = Integer.compare(this.hotfix, other.hotfix);
        if (c != 0) {
            return c;
        }
        c = CassandraVersion.compareIdentifiers(this.preRelease, other.preRelease, 1);
        if (c != 0) {
            return c;
        }
        return CassandraVersion.compareIdentifiers(this.build, other.build, -1);
    }

    private static int compareIdentifiers(String[] ids1, String[] ids2, int defaultPred) {
        if (ids1 == null) {
            return ids2 == null ? 0 : defaultPred;
        }
        if (ids2 == null) {
            return -defaultPred;
        }
        int min = Math.min(ids1.length, ids2.length);
        for (int i = 0; i < min; ++i) {
            Integer i1 = CassandraVersion.tryParseInt(ids1[i]);
            Integer i2 = CassandraVersion.tryParseInt(ids2[i]);
            if (i1 != null) {
                if (i2 == null || i1 < i2) {
                    return -1;
                }
                if (i1 <= i2) continue;
                return 1;
            }
            if (i2 != null) {
                return 1;
            }
            int c = ids1[i].compareToIgnoreCase(ids2[i]);
            if (c == 0) continue;
            return c;
        }
        if (ids1.length < ids2.length) {
            if (ids1.length == 0) {
                return -1;
            }
            return ids2.length - ids1.length == 1 && ids2[ids2.length - 1].equalsIgnoreCase("SNAPSHOT") ? 1 : -1;
        }
        if (ids1.length > ids2.length) {
            if (ids2.length == 0) {
                return 1;
            }
            return ids1.length - ids2.length == 1 && ids1[ids1.length - 1].equalsIgnoreCase("SNAPSHOT") ? -1 : 1;
        }
        return 0;
    }

    private static Integer tryParseInt(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraVersion that = (CassandraVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.hotfix == that.hotfix && Arrays.equals(this.preRelease, that.preRelease) && Arrays.equals(this.build, that.build);
    }

    public int hashCode() {
        int result = Objects.hash(this.major, this.minor, this.patch, this.hotfix);
        result = 31 * result + Arrays.hashCode(this.preRelease);
        result = 31 * result + Arrays.hashCode(this.build);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.hotfix != -1) {
            sb.append('.').append(this.hotfix);
        }
        if (this.preRelease != null) {
            sb.append('-').append(StringUtils.join((Object[])this.preRelease, (String)"."));
        }
        if (this.build != null) {
            sb.append('+').append(StringUtils.join((Object[])this.build, (String)"."));
        }
        return sb.toString();
    }
}

