/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

public enum MessageFlag {
    CALL_BACK_ON_FAILURE(0),
    TRACK_REPAIRED_DATA(1);

    private final int id;
    private static final MessageFlag[] idToFlagMap;

    private MessageFlag(int id) {
        this.id = id;
    }

    boolean isIn(int flags) {
        return (flags & 1 << this.id) != 0;
    }

    int addTo(int flags) {
        return flags | 1 << this.id;
    }

    MessageFlag lookUpById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("MessageFlag id must be non-negative (got " + id + ')');
        }
        return id < idToFlagMap.length ? idToFlagMap[id] : null;
    }

    static {
        MessageFlag[] flags = MessageFlag.values();
        int max = -1;
        for (MessageFlag flag : flags) {
            max = Math.max(flag.id, max);
        }
        MessageFlag[] idMap = new MessageFlag[max + 1];
        for (MessageFlag flag : flags) {
            if (idMap[flag.id] != null) {
                throw new RuntimeException("Two MessageFlag-s that map to the same id: " + flag.id);
            }
            idMap[flag.id] = flag;
        }
        idToFlagMap = idMap;
    }
}

