/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

public abstract class AbstractReplicaCollection<C extends AbstractReplicaCollection<C>>
implements ReplicaCollection<C> {
    protected static final ReplicaList EMPTY_LIST = new ReplicaList();
    protected final ReplicaList list;

    public static <C extends ReplicaCollection<C>, B extends ReplicaCollection.Builder<C>> Collector<Replica, B, C> collector(final Set<Collector.Characteristics> characteristics, final Supplier<B> supplier) {
        return new Collector<Replica, B, C>(){
            private final BiConsumer<B, Replica> accumulator = ReplicaCollection.Builder::add;
            private final BinaryOperator<B> combiner = (a, b) -> {
                a.addAll((Iterable<Replica>)b);
                return a;
            };
            private final Function<B, C> finisher = ReplicaCollection.Builder::build;

            @Override
            public Supplier<B> supplier() {
                return supplier;
            }

            @Override
            public BiConsumer<B, Replica> accumulator() {
                return this.accumulator;
            }

            @Override
            public BinaryOperator<B> combiner() {
                return this.combiner;
            }

            @Override
            public Function<B, C> finisher() {
                return this.finisher;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return characteristics;
            }
        };
    }

    AbstractReplicaCollection(ReplicaList list) {
        this.list = list;
    }

    public abstract ReplicaCollection.Builder<C> newBuilder(int var1);

    abstract C snapshot(ReplicaList var1);

    public abstract C snapshot();

    @Override
    public final C subList(int start, int end) {
        if (start == 0 && end == this.size()) {
            return this.snapshot();
        }
        ReplicaList subList = start == end ? EMPTY_LIST : this.list.subList(start, end);
        return this.snapshot(subList);
    }

    @Override
    public int count(Predicate<Replica> predicate) {
        int count = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!predicate.test(this.list.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final C filter(Predicate<Replica> predicate) {
        return (C)this.filter((Predicate)predicate, Integer.MAX_VALUE);
    }

    @Override
    public final C filter(Predicate<Replica> predicate, int limit) {
        int i;
        if (this.isEmpty()) {
            return this.snapshot();
        }
        ReplicaList copy = null;
        int beginRun = -1;
        int endRun = -1;
        for (i = 0; i < this.list.size(); ++i) {
            Replica replica = this.list.get(i);
            if (predicate.test(replica)) {
                if (copy != null) {
                    copy.add(replica);
                } else if (beginRun < 0) {
                    beginRun = i;
                } else if (endRun > 0) {
                    copy = new ReplicaList(Math.min(limit, this.list.size() - i + (endRun - beginRun)));
                    for (int j = beginRun; j < endRun; ++j) {
                        copy.add(this.list.get(j));
                    }
                    copy.add(this.list.get(i));
                }
                if (--limit != 0) continue;
                ++i;
                break;
            }
            if (beginRun < 0 || endRun >= 0) continue;
            endRun = i;
        }
        if (beginRun < 0) {
            endRun = 0;
            beginRun = 0;
        }
        if (endRun < 0) {
            endRun = i;
        }
        if (copy == null) {
            return (C)this.subList(beginRun, endRun);
        }
        return this.snapshot(copy);
    }

    @Override
    public final Iterable<Replica> filterLazily(Predicate<Replica> predicate) {
        return this.filterLazily(predicate, Integer.MAX_VALUE);
    }

    @Override
    public final Iterable<Replica> filterLazily(Predicate<Replica> predicate, int limit) {
        return () -> this.list.filterIterator(predicate, limit);
    }

    @Override
    public final C sorted(Comparator<Replica> comparator) {
        return this.snapshot(this.list.sorted(comparator));
    }

    @Override
    public final Replica get(int i) {
        return this.list.get(i);
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public final Iterator<Replica> iterator() {
        return this.list.iterator();
    }

    @Override
    public final Stream<Replica> stream() {
        return this.list.stream();
    }

    @Override
    public final boolean equals(Object o) {
        throw new UnsupportedOperationException("AbstractReplicaCollection equals unsupported");
    }

    @Override
    public final int hashCode() {
        throw new UnsupportedOperationException("AbstractReplicaCollection hashCode unsupported");
    }

    @Override
    public final String toString() {
        return Iterables.toString((Iterable)this.list);
    }

    static <C extends AbstractReplicaCollection<C>> C concat(C replicas, C extraReplicas, ReplicaCollection.Builder.Conflict ignoreConflicts) {
        if (extraReplicas.isEmpty()) {
            return replicas;
        }
        if (replicas.isEmpty()) {
            return extraReplicas;
        }
        ReplicaCollection.Builder<C> builder = replicas.newBuilder(replicas.size() + extraReplicas.size());
        builder.addAll(replicas, ReplicaCollection.Builder.Conflict.NONE);
        builder.addAll(extraReplicas, ignoreConflicts);
        return (C)((AbstractReplicaCollection)builder.build());
    }

    protected static class ReplicaMap<K>
    extends AbstractMap<K, Replica> {
        private final Function<Replica, K> toKey;
        private final ReplicaList list;
        private final ObjectIntHashMap<K> map;
        private Set<K> keySet;
        private Set<Map.Entry<K, Replica>> entrySet;

        public ReplicaMap(ReplicaList list, Function<Replica, K> toKey) {
            this.toKey = toKey;
            this.map = new ObjectIntHashMap(list.size == 0 ? list.contents.length : list.size, (double)0.65f);
            this.list = list;
            for (int i = list.begin; i < list.begin + list.size; ++i) {
                boolean inserted = this.internalPutIfAbsent(list.contents[i], i);
                assert (inserted);
            }
        }

        public ReplicaMap(ReplicaList list, Function<Replica, K> toKey, ObjectIntHashMap<K> map) {
            this.toKey = toKey;
            this.list = list;
            this.map = map;
        }

        boolean internalPutIfAbsent(Replica replica, int index) {
            K key = this.toKey.apply(replica);
            int otherIndex = this.map.put(key, index + 1);
            if (otherIndex == 0) {
                return true;
            }
            this.map.put(key, otherIndex);
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            Preconditions.checkNotNull((Object)key);
            return this.get(key) != null;
        }

        @Override
        public Replica get(Object key) {
            Preconditions.checkNotNull((Object)key);
            int index = this.map.get(key) - 1;
            if (index < this.list.begin || index >= this.list.begin + this.list.size) {
                return null;
            }
            return this.list.contents[index];
        }

        @Override
        public Replica remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            KeySet ks = this.keySet;
            if (ks == null) {
                this.keySet = ks = new KeySet();
            }
            return ks;
        }

        @Override
        public Set<Map.Entry<K, Replica>> entrySet() {
            EntrySet es = this.entrySet;
            if (es == null) {
                this.entrySet = es = new EntrySet();
            }
            return es;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        ReplicaMap<K> forSubList(ReplicaList subList) {
            assert (subList.contents == this.list.contents);
            return new ReplicaMap<K>(subList, this.toKey, this.map);
        }

        class EntrySet
        extends AbstractImmutableSet<Map.Entry<K, Replica>> {
            EntrySet() {
            }

            @Override
            public boolean contains(Object o) {
                Preconditions.checkNotNull((Object)o);
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return Objects.equals(ReplicaMap.this.get(((Map.Entry)o).getKey()), ((Map.Entry)o).getValue());
            }

            @Override
            public Iterator<Map.Entry<K, Replica>> iterator() {
                return ReplicaMap.this.list.transformIterator(r -> new AbstractMap.SimpleImmutableEntry(ReplicaMap.this.toKey.apply(r), (Replica)r));
            }
        }

        class KeySet
        extends AbstractImmutableSet<K> {
            KeySet() {
            }

            @Override
            public boolean contains(Object o) {
                return ReplicaMap.this.containsKey(o);
            }

            @Override
            public Iterator<K> iterator() {
                return ReplicaMap.this.list.transformIterator(ReplicaMap.this.toKey);
            }
        }

        abstract class AbstractImmutableSet<T>
        extends AbstractSet<T> {
            AbstractImmutableSet() {
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return ReplicaMap.this.list.size();
            }
        }
    }

    protected static class ReplicaList
    implements Iterable<Replica> {
        private static final Replica[] EMPTY = new Replica[0];
        Replica[] contents;
        int begin;
        int size;

        public ReplicaList() {
            this(0);
        }

        public ReplicaList(int capacity) {
            this.contents = capacity == 0 ? EMPTY : new Replica[capacity];
        }

        public ReplicaList(Replica[] contents, int begin, int size) {
            this.contents = contents;
            this.begin = begin;
            this.size = size;
        }

        public boolean isSubList(ReplicaList subList) {
            return subList.contents == this.contents;
        }

        public Replica get(int index) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.contents[this.begin + index];
        }

        public void add(Replica replica) {
            if (this.begin != 0) {
                throw new IllegalStateException();
            }
            if (this.size == this.contents.length) {
                int newSize = this.size < 3 ? 3 : (this.size < 9 ? 9 : this.size * 2);
                this.contents = Arrays.copyOf(this.contents, newSize);
            }
            this.contents[this.size++] = replica;
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public ReplicaList subList(int begin, int end) {
            if (end > this.size || begin > end) {
                throw new IndexOutOfBoundsException();
            }
            return new ReplicaList(this.contents, this.begin + begin, end - begin);
        }

        public ReplicaList sorted(Comparator<Replica> comparator) {
            Replica[] copy = Arrays.copyOfRange(this.contents, this.begin, this.begin + this.size);
            Arrays.sort(copy, comparator);
            return new ReplicaList(copy, 0, copy.length);
        }

        public Stream<Replica> stream() {
            return Arrays.stream(this.contents, this.begin, this.begin + this.size);
        }

        @Override
        public Iterator<Replica> iterator() {
            return new Iterator<Replica>(){
                final int end;
                int i;
                {
                    this.end = begin + size;
                    this.i = begin;
                }

                @Override
                public boolean hasNext() {
                    return this.i < this.end;
                }

                @Override
                public Replica next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    return contents[this.i++];
                }
            };
        }

        public <K> Iterator<K> transformIterator(final Function<Replica, K> function) {
            return new Iterator<K>(){
                final int end;
                int i;
                {
                    this.end = begin + size;
                    this.i = begin;
                }

                @Override
                public boolean hasNext() {
                    return this.i < this.end;
                }

                @Override
                public K next() {
                    return function.apply(contents[this.i++]);
                }
            };
        }

        private Iterator<Replica> filterIterator(final Predicate<Replica> predicate, final int limit) {
            return new Iterator<Replica>(){
                final int end;
                int next;
                int count;
                {
                    this.end = begin + size;
                    this.next = begin;
                    this.count = 0;
                    this.updateNext();
                }

                void updateNext() {
                    if (this.count == limit) {
                        this.next = this.end;
                    }
                    while (this.next < this.end && !predicate.test(contents[this.next])) {
                        ++this.next;
                    }
                    ++this.count;
                }

                @Override
                public boolean hasNext() {
                    return this.next < this.end;
                }

                @Override
                public Replica next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    Replica result = contents[this.next++];
                    this.updateNext();
                    return result;
                }
            };
        }

        @VisibleForTesting
        public boolean equals(Object to) {
            if (to == null || to.getClass() != ReplicaList.class) {
                return false;
            }
            ReplicaList that = (ReplicaList)to;
            if (this.size != that.size) {
                return false;
            }
            return Iterables.elementsEqual((Iterable)this, (Iterable)that);
        }
    }
}

