/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public abstract class AbstractCell<V>
extends Cell<V> {
    protected AbstractCell(ColumnMetadata column) {
        super(column);
    }

    @Override
    public boolean isCounterCell() {
        return !this.isTombstone() && this.column.isCounterColumn();
    }

    @Override
    public boolean isLive(int nowInSec) {
        return this.localDeletionTime() == Integer.MAX_VALUE || this.ttl() != 0 && nowInSec < this.localDeletionTime();
    }

    @Override
    public boolean isTombstone() {
        return this.localDeletionTime() != Integer.MAX_VALUE && this.ttl() == 0;
    }

    @Override
    public boolean isExpiring() {
        return this.ttl() != 0;
    }

    @Override
    public Cell<?> markCounterLocalToBeCleared() {
        if (!this.isCounterCell()) {
            return this;
        }
        ByteBuffer value = this.buffer();
        ByteBuffer marked = CounterContext.instance().markLocalToBeCleared(value);
        return marked == value ? this : new BufferCell(this.column, this.timestamp(), this.ttl(), this.localDeletionTime(), marked, this.path());
    }

    @Override
    public Cell<?> purge(DeletionPurger purger, int nowInSec) {
        if (!this.isLive(nowInSec)) {
            if (purger.shouldPurge(this.timestamp(), this.localDeletionTime())) {
                return null;
            }
            if (this.isExpiring()) {
                return BufferCell.tombstone(this.column, this.timestamp(), this.localDeletionTime() - this.ttl(), this.path()).purge(purger, nowInSec);
            }
        }
        return this;
    }

    @Override
    public Cell<?> clone(ByteBufferCloner cloner) {
        CellPath path = this.path();
        return new BufferCell(this.column, this.timestamp(), this.ttl(), this.localDeletionTime(), cloner.clone(this.buffer()), path == null ? null : path.clone(cloner));
    }

    @Override
    public Cell<?> updateAllTimestamp(long newTimestamp) {
        return new BufferCell(this.column, this.isTombstone() ? newTimestamp - 1L : newTimestamp, this.ttl(), this.localDeletionTime(), this.buffer(), this.path());
    }

    @Override
    public int dataSize() {
        CellPath path = this.path();
        return TypeSizes.sizeof(this.timestamp()) + TypeSizes.sizeof(this.ttl()) + TypeSizes.sizeof(this.localDeletionTime()) + this.valueSize() + (path == null ? 0 : path.dataSize());
    }

    @Override
    public void digest(Digest digest) {
        if (this.isCounterCell()) {
            digest.updateWithCounterContext(this.value(), this.accessor());
        } else {
            digest.update(this.value(), this.accessor());
        }
        digest.updateWithLong(this.timestamp()).updateWithInt(this.ttl()).updateWithBoolean(this.isCounterCell());
        if (this.path() != null) {
            this.path().digest(digest);
        }
    }

    @Override
    public void validate() {
        if (this.ttl() < 0) {
            throw new MarshalException("A TTL should not be negative");
        }
        if (this.localDeletionTime() < 0) {
            throw new MarshalException("A local deletion time should not be negative");
        }
        if (this.isExpiring() && this.localDeletionTime() == Integer.MAX_VALUE) {
            throw new MarshalException("Shoud not have a TTL without an associated local deletion time");
        }
        this.column().validateCell(this);
    }

    @Override
    public boolean hasInvalidDeletions() {
        return this.ttl() < 0 || this.localDeletionTime() < 0 || this.isExpiring() && this.localDeletionTime() == Integer.MAX_VALUE;
    }

    @Override
    public long maxTimestamp() {
        return this.timestamp();
    }

    public static <V1, V2> boolean equals(Cell<V1> left, Cell<V2> right) {
        return left.column().equals(right.column()) && left.isCounterCell() == right.isCounterCell() && left.timestamp() == right.timestamp() && left.ttl() == right.ttl() && left.localDeletionTime() == right.localDeletionTime() && ValueAccessor.equals(left.value(), left.accessor(), right.value(), right.accessor()) && Objects.equals(left.path(), right.path());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Cell)) {
            return false;
        }
        return AbstractCell.equals(this, (Cell)other);
    }

    public int hashCode() {
        return Objects.hash(this.column(), this.isCounterCell(), this.timestamp(), this.ttl(), this.localDeletionTime(), this.accessor().hashCode(this.value()), this.path());
    }

    public String toString() {
        if (this.isCounterCell()) {
            return String.format("[%s=%d ts=%d]", this.column().name, CounterContext.instance().total(this.value(), this.accessor()), this.timestamp());
        }
        AbstractType type = this.column().type;
        if (type instanceof CollectionType && type.isMultiCell()) {
            CollectionType ct = (CollectionType)type;
            return String.format("[%s[%s]=%s %s]", this.column().name, ct.nameComparator().getString(this.path().get(0)), ct.valueComparator().getString(this.value(), this.accessor()), this.livenessInfoString());
        }
        if (this.isTombstone()) {
            return String.format("[%s=<tombstone> %s]", this.column().name, this.livenessInfoString());
        }
        return String.format("[%s=%s %s]", this.column().name, this.safeToString(type), this.livenessInfoString());
    }

    private String safeToString(AbstractType<?> type) {
        try {
            return type.getString(this.value(), this.accessor());
        }
        catch (Exception e) {
            return "0x" + ByteBufferUtil.bytesToHex(this.buffer());
        }
    }

    private String livenessInfoString() {
        if (this.isExpiring()) {
            return String.format("ts=%d ttl=%d ldt=%d", this.timestamp(), this.ttl(), this.localDeletionTime());
        }
        if (this.isTombstone()) {
            return String.format("ts=%d ldt=%d", this.timestamp(), this.localDeletionTime());
        }
        return String.format("ts=%d", this.timestamp());
    }
}

