/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimeUUIDSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.UUIDGen;

public class TimeUUIDType
extends TemporalType<UUID> {
    public static final TimeUUIDType instance = new TimeUUIDType();

    TimeUUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        boolean p2;
        boolean p1 = accessorL.size(left) == 16;
        boolean bl = p2 = accessorR.size(right) == 16;
        if (!(p1 & p2)) {
            assert (p1 || accessorL.isEmpty(left));
            assert (p2 || accessorR.isEmpty(right));
            return p1 ? 1 : (p2 ? -1 : 0);
        }
        long msb1 = accessorL.getLong(left, 0);
        long msb2 = accessorR.getLong(right, 0);
        msb1 = TimeUUIDType.reorderTimestampBytes(msb1);
        msb2 = TimeUUIDType.reorderTimestampBytes(msb2);
        assert ((msb1 & TimeUUIDType.topbyte(240L)) == TimeUUIDType.topbyte(16L));
        assert ((msb2 & TimeUUIDType.topbyte(240L)) == TimeUUIDType.topbyte(16L));
        int c = Long.compare(msb1, msb2);
        if (c != 0) {
            return c;
        }
        long lsb1 = TimeUUIDType.signedBytesToNativeLong(accessorL.getLong(left, 8));
        long lsb2 = TimeUUIDType.signedBytesToNativeLong(accessorR.getLong(right, 8));
        return Long.compare(lsb1, lsb2);
    }

    private static long signedBytesToNativeLong(long signedBytes) {
        return signedBytes ^ 0x80808080808080L;
    }

    private static long topbyte(long topbyte) {
        return topbyte << 56;
    }

    protected static long reorderTimestampBytes(long input) {
        return input << 48 | input << 16 & 0xFFFF00000000L | input >>> 32;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        ByteBuffer parsed = UUIDType.parse(source);
        if (parsed == null) {
            throw new MarshalException(String.format("Unknown timeuuid representation: %s", source));
        }
        if (parsed.remaining() == 16 && UUIDType.version(parsed) != 1) {
            throw new MarshalException("TimeUUID supports only version 1 UUIDs");
        }
        return parsed;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a timeuuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMEUUID;
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return TimeUUIDSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 16;
    }

    @Override
    public long toTimeInMillis(ByteBuffer value) {
        return UUIDGen.unixTimestamp(UUIDGen.getUUID(value));
    }

    @Override
    public ByteBuffer addDuration(ByteBuffer temporal, ByteBuffer duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer substractDuration(ByteBuffer temporal, ByteBuffer duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer now() {
        return ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
    }
}

