/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.springboot;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class CosmosDbComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, CosmosDbConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CosmosAsyncClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ThroughputProperties.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ChangeFeedProcessorOptions.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CosmosQueryRequestOptions.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration": {
                return this.applicationContext.getBean(ref, CosmosDbConfiguration.class);
            }
            case "com.azure.cosmos.CosmosAsyncClient": {
                return this.applicationContext.getBean(ref, CosmosAsyncClient.class);
            }
            case "com.azure.cosmos.models.ThroughputProperties": {
                return this.applicationContext.getBean(ref, ThroughputProperties.class);
            }
            case "com.azure.cosmos.models.ChangeFeedProcessorOptions": {
                return this.applicationContext.getBean(ref, ChangeFeedProcessorOptions.class);
            }
            case "com.azure.cosmos.models.CosmosQueryRequestOptions": {
                return this.applicationContext.getBean(ref, CosmosQueryRequestOptions.class);
            }
        }
        return null;
    }
}

