/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategyDefault;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategyLegacy;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryFactory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyConfiguration;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.spi.InstrumentedThreadPoolFactory;
import org.apache.camel.quarkus.component.micrometer.CamelMicrometerConfig;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.ThreadPoolFactory;

@Recorder
public class CamelMicrometerRecorder {
    public RuntimeValue<CamelContextCustomizer> createContextCustomizer(CamelMicrometerConfig config) {
        return new RuntimeValue((Object)new MicrometerContextCustomizer(config));
    }

    public RuntimeValue<CamelContextCustomizer> createRuntimeContextCustomizer(CamelMicrometerConfig config, RuntimeValue<MeterRegistry> meterRegistry) {
        return new RuntimeValue((Object)new MicrometerRuntimeContextCustomizer(config, (MeterRegistry)meterRegistry.getValue()));
    }

    public void configureDefaultRegistry(RuntimeValue<MeterRegistry> rootMeterRegistry) {
        if (rootMeterRegistry.getValue() instanceof CompositeMeterRegistry) {
            ((CompositeMeterRegistry)rootMeterRegistry.getValue()).add(MicrometerUtils.createMeterRegistry());
        }
    }

    private static class MicrometerContextCustomizer
    implements CamelContextCustomizer {
        private final CamelMicrometerConfig config;

        public MicrometerContextCustomizer(CamelMicrometerConfig config) {
            this.config = config;
        }

        public void configure(CamelContext camelContext) {
            MicrometerExchangeEventNotifier eventNotifier;
            if (this.config.enableRoutePolicy()) {
                MicrometerRoutePolicyFactory factory = new MicrometerRoutePolicyFactory();
                factory.setCamelContext(camelContext);
                camelContext.addRoutePolicyFactory((RoutePolicyFactory)factory);
                if (this.config.namingStrategy().equals((Object)CamelMicrometerConfig.MetricsNamingStrategy.LEGACY)) {
                    factory.setNamingStrategy(MicrometerRoutePolicyNamingStrategy.LEGACY);
                }
                MicrometerRoutePolicyConfiguration policyConfiguration = factory.getPolicyConfiguration();
                if (this.config.routePolicyLevel().equals((Object)CamelMicrometerConfig.RoutePolicyLevel.ALL)) {
                    factory.getPolicyConfiguration().setContextEnabled(true);
                    factory.getPolicyConfiguration().setRouteEnabled(true);
                } else if (this.config.routePolicyLevel().equals((Object)CamelMicrometerConfig.RoutePolicyLevel.CONTEXT)) {
                    factory.getPolicyConfiguration().setContextEnabled(true);
                    factory.getPolicyConfiguration().setRouteEnabled(false);
                } else {
                    policyConfiguration.setContextEnabled(false);
                    policyConfiguration.setRouteEnabled(true);
                }
                this.config.routePolicyExcludePattern().ifPresent(arg_0 -> ((MicrometerRoutePolicyConfiguration)policyConfiguration).setExcludePattern(arg_0));
            }
            ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
            if (this.config.enableExchangeEventNotifier()) {
                eventNotifier = new MicrometerExchangeEventNotifier();
                eventNotifier.setBaseEndpointURI(this.config.baseEndpointURIExchangeEventNotifier());
                if (this.config.namingStrategy().equals((Object)CamelMicrometerConfig.MetricsNamingStrategy.LEGACY)) {
                    eventNotifier.setNamingStrategy((MicrometerExchangeEventNotifierNamingStrategy)new MicrometerExchangeEventNotifierNamingStrategyLegacy(this.config.baseEndpointURIExchangeEventNotifier()));
                } else {
                    eventNotifier.setNamingStrategy((MicrometerExchangeEventNotifierNamingStrategy)new MicrometerExchangeEventNotifierNamingStrategyDefault(this.config.baseEndpointURIExchangeEventNotifier()));
                }
                managementStrategy.addEventNotifier((EventNotifier)eventNotifier);
            }
            if (this.config.enableRouteEventNotifier()) {
                eventNotifier = new MicrometerRouteEventNotifier();
                if (this.config.namingStrategy().equals((Object)CamelMicrometerConfig.MetricsNamingStrategy.LEGACY)) {
                    eventNotifier.setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy.LEGACY);
                }
                managementStrategy.addEventNotifier((EventNotifier)eventNotifier);
            }
        }
    }

    private static class MicrometerRuntimeContextCustomizer
    implements CamelContextCustomizer {
        private final CamelMicrometerConfig config;
        private final MeterRegistry meterRegistry;

        public MicrometerRuntimeContextCustomizer(CamelMicrometerConfig config, MeterRegistry meterRegistry) {
            this.config = config;
            this.meterRegistry = meterRegistry;
        }

        public void configure(CamelContext camelContext) {
            if (this.config.enableInstrumentedThreadPoolFactory()) {
                InstrumentedThreadPoolFactory instrumentedThreadPoolFactory = new InstrumentedThreadPoolFactory(this.meterRegistry, camelContext.getExecutorServiceManager().getThreadPoolFactory());
                camelContext.getExecutorServiceManager().setThreadPoolFactory((ThreadPoolFactory)instrumentedThreadPoolFactory);
            }
            if (!this.config.enableMessageHistory()) {
                return;
            }
            if (!camelContext.isMessageHistory().booleanValue()) {
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            MicrometerMessageHistoryFactory messageHistoryFactory = new MicrometerMessageHistoryFactory();
            if (this.config.namingStrategy().equals((Object)CamelMicrometerConfig.MetricsNamingStrategy.LEGACY)) {
                messageHistoryFactory.setNamingStrategy(MicrometerMessageHistoryNamingStrategy.LEGACY);
            }
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)messageHistoryFactory);
        }
    }
}

