/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.camel.quarkus.test.CallbackUtil;
import org.apache.camel.quarkus.test.ContextNotStoppingManagerFactory;
import org.apache.camel.quarkus.test.CustomCamelContextConfiguration;
import org.apache.camel.quarkus.test.CustomTestExecutionConfiguration;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.AbstractTestSupport;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CamelContextManager;
import org.apache.camel.test.junit5.ContextManagerFactory;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.junit5.util.ExtensionHelper;
import org.apache.camel.test.junit5.util.RouteCoverageDumperExtension;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelQuarkusTestSupport
extends AbstractTestSupport
implements QuarkusTestProfile {
    private static final Logger LOG = LoggerFactory.getLogger(CamelQuarkusTestSupport.class);
    private final StopWatch watch = new StopWatch();
    private String currentTestName;
    private CamelContextManager contextManager;
    private final ContextManagerFactory contextManagerFactory = new ContextNotStoppingManagerFactory();
    @Inject
    protected CamelContext context;
    private Set<String> createdRoutes;

    public CamelQuarkusTestSupport() {
        super((TestExecutionConfiguration)new CustomTestExecutionConfiguration(), (CamelContextConfiguration)new CustomCamelContextConfiguration());
        this.testConfigurationBuilder().withCustomUseAdviceWith(this.isUseAdviceWith()).withJMX(this.useJmx()).withUseRouteBuilder(this.isUseRouteBuilder()).withDumpRouteCoverage(this.isDumpRouteCoverage()).withAutoStartContext(false);
        this.contextConfiguration().withCustomCamelContextSupplier(this::camelContextSupplier).withCustomPostProcessor(this::postProcessTest).withCustomRoutesSupplier(this::createRouteBuilders).withRegistryBinder(this::bindToRegistry).withUseOverridePropertiesWithPropertiesComponent(this.useOverridePropertiesWithPropertiesComponent()).withRouteFilterExcludePattern(this.getRouteFilterExcludePattern()).withRouteFilterIncludePattern(this.getRouteFilterIncludePattern()).withMockEndpoints(this.isMockEndpoints()).withMockEndpointsAndSkip(this.isMockEndpointsAndSkip());
        this.testConfiguration().withAutoStartContext(false);
    }

    CustomCamelContextConfiguration contextConfiguration() {
        return (CustomCamelContextConfiguration)this.camelContextConfiguration;
    }

    CustomTestExecutionConfiguration testConfigurationBuilder() {
        return (CustomTestExecutionConfiguration)this.testConfigurationBuilder;
    }

    protected void doAfterAll(QuarkusTestContext context) throws Exception {
    }

    protected void doAfterEach(QuarkusTestMethodContext context) throws Exception {
    }

    protected void doAfterConstruct() throws Exception {
    }

    protected void doBeforeEach(QuarkusTestMethodContext context) throws Exception {
    }

    protected CamelContext camelContextSupplier() throws Exception {
        return this.context;
    }

    protected void bindToRegistry(Registry registry) throws Exception {
        this.assertTestClassCamelContextMatchesAppCamelContext();
    }

    @Deprecated(since="3.15.0")
    protected void postProcessTest() throws Exception {
        this.assertTestClassCamelContextMatchesAppCamelContext();
        this.template = this.contextManager.template();
        this.fluentTemplate = this.contextManager.fluentTemplate();
        this.consumer = this.contextManager.consumer();
    }

    public CamelContext context() {
        return this.context;
    }

    @Deprecated(since="3.15.0")
    public long timeTaken() {
        return this.watch.taken();
    }

    public final String getCurrentTestName() {
        return this.currentTestName;
    }

    @Deprecated(since="3.15.0")
    public void setUp() throws Exception {
        ExtensionHelper.testStartHeader(((Object)((Object)this)).getClass(), (String)this.currentTestName);
        this.setupResources();
        this.doPreSetup();
        this.contextManager.createCamelContext((Object)this);
        this.context = this.contextManager.context();
        if (this.isUseRouteBuilder() && !this.context.getRegistry().findByType(RouteBuilder.class).isEmpty()) {
            LOG.warn("isUseRouteBuilder = true and RouteBuilder beans are present in the Camel registry.\nAll tests will share their routes. If this is not desired, define your test routes by overriding CamelQuarkusTestSupport.createRouteBuilder().\nOr use configuration properties quarkus.camel.routes-discovery.exclude-patterns or quarkus.camel.routes-discovery.include-patterns to control which routes are started.");
        }
        this.doPostSetup();
        this.watch.restart();
    }

    @Deprecated(since="3.15.0")
    public void tearDown() throws Exception {
        long time = this.watch.taken();
        if (this.isRouteCoverageEnabled()) {
            ExtensionHelper.testEndFooter(((Object)((Object)this)).getClass(), (String)this.currentTestName, (long)time, (RouteCoverageDumperExtension)new RouteCoverageDumperExtension((ModelCamelContext)this.context));
        } else {
            ExtensionHelper.testEndFooter(((Object)((Object)this)).getClass(), (String)this.currentTestName, (long)time);
        }
        if (this.testConfigurationBuilder.isCreateCamelContextPerClass()) {
            return;
        }
        LOG.debug("tearDown()");
        this.contextManager.stop();
        this.doPostTearDown();
        this.cleanupResources();
    }

    @Deprecated(since="3.15.0")
    protected void doPostTearDown() throws Exception {
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    @Deprecated(since="3.15.0")
    protected RoutesBuilder[] createRouteBuilders() throws Exception {
        return new RoutesBuilder[]{this.createRouteBuilder()};
    }

    void internalAfterAll() {
        try {
            if (this.testConfiguration().isCreateCamelContextPerClass()) {
                this.contextManager.stop();
            } else {
                this.doPostTearDown();
            }
            this.cleanupResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void internalBeforeAll(CallbackUtil.MockExtensionContext context) {
        boolean perClassPresent = context.getTestInstanceLifecycle().filter(lc -> lc.equals((Object)TestInstance.Lifecycle.PER_CLASS)).isPresent();
        if (perClassPresent) {
            LOG.trace("Creating a legacy context manager for {}", (Object)context.getDisplayName());
            this.testConfigurationBuilder().withCustomCreateCamelContextPerClass(perClassPresent);
            this.contextManager = this.contextManagerFactory.createContextManager(ContextManagerFactory.Type.BEFORE_ALL, this.testConfigurationBuilder, this.camelContextConfiguration);
        }
        ExtensionContext.Store globalStore = context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.contextManager.setGlobalStore(globalStore);
    }

    void internalBeforeEach(CallbackUtil.MockExtensionContext context) throws Exception {
        if (this.contextManager == null) {
            LOG.trace("Creating a transient context manager for {}", (Object)context.getDisplayName());
            this.contextManager = this.contextManagerFactory.createContextManager(ContextManagerFactory.Type.BEFORE_EACH, this.testConfigurationBuilder, this.camelContextConfiguration);
        }
        this.currentTestName = context.getDisplayName();
        ExtensionContext.Store globalStore = context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.contextManager.setGlobalStore(globalStore);
    }

    @Deprecated(since="3.15.0")
    protected void doPreSetup() throws Exception {
        if (this.isUseAdviceWith() || this.isUseDebugger()) {
            ((FastCamelContext)this.context).suspend();
        }
        if (this.isUseRouteBuilder()) {
            this.createdRoutes = this.context.getRoutes().stream().map(Route::getRouteId).collect(Collectors.toSet());
        }
    }

    @Deprecated(since="3.15.0")
    protected void doPostSetup() throws Exception {
        if (this.isUseAdviceWith() || this.isUseDebugger()) {
            ((FastCamelContext)this.context).resume();
            if (this.isUseDebugger()) {
                ModelCamelContext mcc = (ModelCamelContext)this.context;
                List rdfs = mcc.getRouteDefinitions();
                mcc.addRouteDefinitions((Collection)rdfs);
            }
        }
        if (this.isUseRouteBuilder()) {
            Set allRoutes = this.context.getRoutes().stream().map(Route::getRouteId).collect(Collectors.toSet());
            if (this.createdRoutes != null) {
                allRoutes.removeAll(this.createdRoutes);
            }
            this.createdRoutes = allRoutes;
        }
    }

    @Deprecated(since="3.15.0")
    public boolean isUseAdviceWith() {
        return false;
    }

    protected void startRouteDefinitions() throws Exception {
        ModelCamelContext modelCamelContext = (ModelCamelContext)this.context;
        ArrayList definitions = new ArrayList(modelCamelContext.getRouteDefinitions());
        for (Route r : this.context.getRoutes()) {
            definitions.remove(r.getRoute());
        }
        modelCamelContext.startRouteDefinitions(definitions);
    }

    protected final MockEndpoint getMockEndpoint(String uri) {
        return this.getMockEndpoint(uri, true);
    }

    @Deprecated(since="3.15.0")
    protected final MockEndpoint getMockEndpoint(String uri, boolean create) throws NoSuchEndpointException {
        return TestSupport.getMockEndpoint((CamelContext)this.context, (String)uri, (boolean)create);
    }

    @Deprecated(since="3.15.0")
    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label) {
    }

    @Deprecated(since="3.15.0")
    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label, long timeTaken) {
    }

    Set<String> getCreatedRoutes() {
        return this.createdRoutes;
    }

    private void assertTestClassCamelContextMatchesAppCamelContext() {
        Assertions.assertEquals((Object)this.context, (Object)this.contextManager.context(), (String)"CamelQuarkusTestSupport uses a different CamelContext compared to the application under test");
    }

    public void configureContext(CamelContextConfiguration camelContextConfiguration) {
    }

    public void configureTest(TestExecutionConfiguration testExecutionConfiguration) {
    }
}

