/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.test.CamelQuarkusTestSupport;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

public class CallbackUtil {
    private CallbackUtil() {
    }

    static boolean isPerClass(CamelQuarkusTestSupport testSupport) {
        return CallbackUtil.getLifecycle(testSupport).filter(lc -> lc.equals((Object)TestInstance.Lifecycle.PER_CLASS)).isPresent();
    }

    static Optional<TestInstance.Lifecycle> getLifecycle(CamelQuarkusTestSupport testSupport) {
        if (((Object)((Object)testSupport)).getClass().getAnnotation(TestInstance.class) != null) {
            return Optional.of(((Object)((Object)testSupport)).getClass().getAnnotation(TestInstance.class).value());
        }
        return Optional.empty();
    }

    static void resetContext(CamelQuarkusTestSupport testInstance) {
        Set<String> createdRoutes = testInstance.getCreatedRoutes();
        if (testInstance.isUseRouteBuilder() && createdRoutes != null) {
            try {
                for (String r : createdRoutes) {
                    testInstance.context().getRouteController().stopRoute(r);
                    testInstance.context().removeRoute(r);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        testInstance.context().getComponentNames().forEach(cn -> testInstance.context().removeComponent(cn));
        MockEndpoint.resetMocks((CamelContext)testInstance.context());
    }

    static class MockExtensionContext {
        private final Optional<TestInstance.Lifecycle> lifecycle;
        private final String currentTestName;
        private final ExtensionContext.Store globalStore;

        public MockExtensionContext(Optional<TestInstance.Lifecycle> lifecycle, String currentTestName) {
            this.lifecycle = lifecycle;
            this.currentTestName = currentTestName;
            this.globalStore = new NamespaceAwareStore(new NamespacedHierarchicalStore(null), ExtensionContext.Namespace.GLOBAL);
        }

        public String getDisplayName() {
            return this.currentTestName;
        }

        public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
            return this.lifecycle;
        }

        public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
            if (namespace == ExtensionContext.Namespace.GLOBAL) {
                return this.globalStore;
            }
            return null;
        }
    }
}

