/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRoutesDefinition;
import org.apache.camel.model.app.BeansDefinition;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.CachedResource;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.scan.PackageScanHelper;
import org.apache.camel.xml.in.ModelParser;
import org.apache.camel.xml.io.util.XmlStreamDetector;
import org.apache.camel.xml.io.util.XmlStreamInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ManagedResource(description="Managed XML RoutesBuilderLoader")
@RoutesLoader(value="xml")
public class XmlRoutesBuilderLoader
extends RouteBuilderLoaderSupport {
    public static final Logger LOG = LoggerFactory.getLogger(XmlRoutesBuilderLoader.class);
    public static final String EXTENSION = "xml";
    public static final String NAMESPACE = "http://camel.apache.org/schema/spring";
    private static final List<String> NAMESPACES = List.of("", "http://camel.apache.org/schema/spring");
    private final Map<String, Boolean> preparseDone = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Resource> resourceCache = new ConcurrentHashMap<String, Resource>();
    private final Map<String, XmlStreamInfo> xmlInfoCache = new ConcurrentHashMap<String, XmlStreamInfo>();
    private final Map<String, BeansDefinition> camelAppCache = new ConcurrentHashMap<String, BeansDefinition>();
    private final List<RegistryBeanDefinition> delayedRegistrations = new ArrayList<RegistryBeanDefinition>();
    private final AtomicInteger counter = new AtomicInteger(0);

    public XmlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    XmlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    public void preParseRoute(Resource resource) throws Exception {
        String root;
        if (this.preparseDone.getOrDefault(resource.getLocation(), false).booleanValue()) {
            return;
        }
        XmlStreamInfo xmlInfo = this.xmlInfo(resource);
        if (xmlInfo.isValid() && ("beans".equals(root = xmlInfo.getRootElementName()) || "camel".equals(root))) {
            new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseBeansDefinition().ifPresent(bd -> {
                this.registerBeans(resource, (BeansDefinition)bd);
                this.camelAppCache.put(resource.getLocation(), (BeansDefinition)bd);
            });
        }
        this.preparseDone.put(resource.getLocation(), true);
    }

    public RouteBuilder doLoadRouteBuilder(final Resource input) throws Exception {
        final Resource resource = this.resource(input);
        final XmlStreamInfo xmlInfo = this.xmlInfo(input);
        if (!xmlInfo.isValid()) {
            LOG.warn("Invalid XML document: {}", (Object)xmlInfo.getProblem().getMessage());
            return null;
        }
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                String resourceLocation = input.getLocation();
                switch (xmlInfo.getRootElementName()) {
                    case "beans": 
                    case "camel": {
                        BeansDefinition def = XmlRoutesBuilderLoader.this.camelAppCache.get(resourceLocation);
                        if (def != null) {
                            this.configureCamel(def);
                            break;
                        }
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseBeansDefinition().ifPresent(this::configureCamel);
                        break;
                    }
                    case "routeTemplate": 
                    case "routeTemplates": {
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseRouteTemplatesDefinition().ifPresent(arg_0 -> (this).setRouteTemplateCollection(arg_0));
                        break;
                    }
                    case "templatedRoutes": 
                    case "templatedRoute": {
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseTemplatedRoutesDefinition().ifPresent(arg_0 -> (this).setTemplatedRouteCollection(arg_0));
                        break;
                    }
                    case "rests": 
                    case "rest": {
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseRestsDefinition().ifPresent(arg_0 -> (this).setRestCollection(arg_0));
                        break;
                    }
                    case "routes": 
                    case "route": {
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseRoutesDefinition().ifPresent(this::addRoutes);
                        break;
                    }
                }
                XmlRoutesBuilderLoader.this.resourceCache.remove(resourceLocation);
                XmlRoutesBuilderLoader.this.xmlInfoCache.remove(resourceLocation);
                XmlRoutesBuilderLoader.this.camelAppCache.remove(resourceLocation);
                XmlRoutesBuilderLoader.this.preparseDone.remove(resourceLocation);
            }

            public void configuration() throws Exception {
                switch (xmlInfo.getRootElementName()) {
                    case "routeConfigurations": 
                    case "routeConfiguration": {
                        new ModelParser(resource, xmlInfo.getRootElementNamespace()).parseRouteConfigurationsDefinition().ifPresent(this::addConfigurations);
                        break;
                    }
                }
            }

            private void configureCamel(BeansDefinition app) {
                if (!XmlRoutesBuilderLoader.this.delayedRegistrations.isEmpty()) {
                    for (RegistryBeanDefinition bean : XmlRoutesBuilderLoader.this.delayedRegistrations) {
                        XmlRoutesBuilderLoader.this.registerBeanDefinition(bean, false);
                    }
                    XmlRoutesBuilderLoader.this.delayedRegistrations.clear();
                }
                app.getRests().forEach(r -> {
                    ArrayList<RestDefinition> list = new ArrayList<RestDefinition>();
                    list.add((RestDefinition)r);
                    RestsDefinition def = new RestsDefinition();
                    def.setRests(list);
                    this.setRestCollection(def);
                });
                app.getRouteConfigurations().forEach(rc -> {
                    ArrayList<RouteConfigurationDefinition> list = new ArrayList<RouteConfigurationDefinition>();
                    list.add((RouteConfigurationDefinition)rc);
                    RouteConfigurationsDefinition def = new RouteConfigurationsDefinition();
                    def.setRouteConfigurations(list);
                    this.addConfigurations(def);
                });
                app.getRouteTemplates().forEach(rt -> {
                    ArrayList<RouteTemplateDefinition> list = new ArrayList<RouteTemplateDefinition>();
                    list.add((RouteTemplateDefinition)rt);
                    RouteTemplatesDefinition def = new RouteTemplatesDefinition();
                    def.setRouteTemplates(list);
                    this.setRouteTemplateCollection(def);
                });
                app.getTemplatedRoutes().forEach(tr -> {
                    ArrayList<TemplatedRouteDefinition> list = new ArrayList<TemplatedRouteDefinition>();
                    list.add((TemplatedRouteDefinition)tr);
                    TemplatedRoutesDefinition def = new TemplatedRoutesDefinition();
                    def.setTemplatedRoutes(list);
                    this.setTemplatedRouteCollection(def);
                });
                app.getRoutes().forEach(r -> {
                    ArrayList<RouteDefinition> list = new ArrayList<RouteDefinition>();
                    list.add((RouteDefinition)r);
                    RoutesDefinition def = new RoutesDefinition();
                    def.setRoutes(list);
                    this.addRoutes(def);
                });
            }

            private void addRoutes(RoutesDefinition routes) {
                CamelContextAware.trySetCamelContext((Object)routes, (CamelContext)this.getCamelContext());
                for (RouteDefinition route : routes.getRoutes()) {
                    this.getRouteCollection().route(route);
                }
            }

            private void addConfigurations(RouteConfigurationsDefinition configurations) {
                CamelContextAware.trySetCamelContext((Object)configurations, (CamelContext)this.getCamelContext());
                for (RouteConfigurationDefinition config : configurations.getRouteConfigurations()) {
                    this.getRouteConfigurationCollection().routeConfiguration(config);
                }
            }
        };
    }

    private Resource resource(Resource resource) {
        return this.resourceCache.computeIfAbsent(resource.getLocation(), l -> new CachedResource(resource));
    }

    private XmlStreamInfo xmlInfo(Resource resource) {
        return this.xmlInfoCache.computeIfAbsent(resource.getLocation(), l -> {
            try {
                XmlStreamDetector detector = new XmlStreamDetector(resource.getInputStream());
                return detector.information();
            }
            catch (IOException e) {
                XmlStreamInfo invalid = new XmlStreamInfo();
                invalid.setProblem((Throwable)e);
                return invalid;
            }
        });
    }

    private void registerBeans(Resource resource, BeansDefinition app) {
        LinkedHashSet packagesToScan = new LinkedHashSet();
        app.getComponentScanning().forEach(cs -> packagesToScan.add(cs.getBasePackage()));
        PackageScanHelper.registerBeans((CamelContext)this.getCamelContext(), packagesToScan);
        for (RegistryBeanDefinition bean : app.getBeans()) {
            this.registerBeanDefinition(bean, true);
        }
        if (!app.getSpringBeans().isEmpty()) {
            Document doc = ((Element)app.getSpringBeans().get(0)).getOwnerDocument();
            String id = String.format("spring-document:%05d:%s", this.counter.incrementAndGet(), resource.getLocation());
            this.getCamelContext().getRegistry().bind(id, (Object)doc);
        }
    }

    private void registerBeanDefinition(RegistryBeanDefinition def, boolean delayIfFailed) {
        Object type = def.getType();
        String name = def.getName();
        if (name == null || "".equals(name.trim())) {
            name = type;
        }
        if (type != null && !((String)type).startsWith("#")) {
            type = "#class:" + (String)type;
            try {
                Object target = PropertyBindingSupport.resolveBean((CamelContext)this.getCamelContext(), (Object)type);
                if (def.getProperties() != null && !def.getProperties().isEmpty()) {
                    PropertyBindingSupport.setPropertiesOnTarget((CamelContext)this.getCamelContext(), (Object)target, (Map)def.getProperties());
                }
                this.getCamelContext().getRegistry().unbind(name);
                this.getCamelContext().getRegistry().bind(name, target);
            }
            catch (Exception e) {
                if (delayIfFailed) {
                    this.delayedRegistrations.add(def);
                }
                LOG.warn("Problem creating bean {}", type, (Object)e);
            }
        }
    }
}

