/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.AbstractRedisProcessorCreator;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;

public final class GeoRedisProcessorsCreator
extends AbstractRedisProcessorCreator {
    Map<Command, Processor> getProcessors(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.bind(Command.GEOADD, this.wrap(exchange -> redisClient.geoadd(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getLongitude((Exchange)exchange), exchangeConverter.getLatitude((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.GEODIST, this.wrap(exchange -> redisClient.geodist(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValuesAsCollection((Exchange)exchange).toArray()[0], exchangeConverter.getValuesAsCollection((Exchange)exchange).toArray()[1])));
        this.bind(Command.GEOHASH, this.wrap(exchange -> redisClient.geohash(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.GEOPOS, this.wrap(exchange -> redisClient.geopos(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange))));
        this.bind(Command.GEORADIUS, this.wrap(exchange -> redisClient.georadius(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getLongitude((Exchange)exchange), exchangeConverter.getLatitude((Exchange)exchange), exchangeConverter.getRadius((Exchange)exchange), exchangeConverter.getCount((Exchange)exchange))));
        this.bind(Command.GEORADIUSBYMEMBER, this.wrap(exchange -> redisClient.georadius(exchangeConverter.getKey((Exchange)exchange), exchangeConverter.getValue((Exchange)exchange), exchangeConverter.getRadius((Exchange)exchange), exchangeConverter.getCount((Exchange)exchange))));
        return this.result;
    }
}

