/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.KafkaFetchRecords;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.PollOnError;
import org.apache.camel.component.kafka.consumer.errorhandler.BridgeErrorStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.DiscardErrorStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.ReconnectErrorStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.RetryErrorStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.StopErrorStrategy;
import org.apache.kafka.clients.consumer.Consumer;

public final class KafkaErrorStrategies {
    private KafkaErrorStrategies() {
    }

    public static PollExceptionStrategy strategies(KafkaFetchRecords recordFetcher, KafkaEndpoint endpoint, Consumer<?, ?> consumer) {
        assert (consumer != null);
        PollExceptionStrategy strategy = endpoint.getComponent().getPollExceptionStrategy();
        if (strategy != null) {
            return strategy;
        }
        PollOnError onError = endpoint.getConfiguration().getPollOnError();
        switch (onError) {
            case RETRY: {
                return new RetryErrorStrategy();
            }
            case RECONNECT: {
                return new ReconnectErrorStrategy(recordFetcher);
            }
            case ERROR_HANDLER: {
                return new BridgeErrorStrategy(recordFetcher, consumer);
            }
            case DISCARD: {
                return new DiscardErrorStrategy(consumer);
            }
            case STOP: {
                return new StopErrorStrategy(recordFetcher);
            }
        }
        throw new RuntimeCamelException("The provided pollOnError strategy is invalid");
    }
}

