/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Option;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.jsonpath.JsonPathEngine;
import org.apache.camel.support.ExpressionAdapter;

public class JsonPathExpression
extends ExpressionAdapter
implements AfterPropertiesConfigured {
    private final String expression;
    private JsonPathEngine engine;
    private Class<?> resultType;
    private boolean suppressExceptions;
    private Option[] options;

    public JsonPathExpression(String expression) {
        this.expression = expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option[] options) {
        this.options = options;
    }

    public Object evaluate(Exchange exchange) {
        try {
            Object result = this.evaluateJsonPath(exchange, this.engine);
            if (this.resultType != null) {
                return exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
        this.init();
    }

    public void init() {
        try {
            this.engine = new JsonPathEngine(this.expression, this.suppressExceptions, this.options);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(this.expression, (Throwable)e);
        }
    }

    public String toString() {
        return "jsonpath[" + this.expression + "]";
    }

    private Object evaluateJsonPath(Exchange exchange, JsonPathEngine engine) throws Exception {
        return engine.read(exchange);
    }
}

